/* imphandl.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

int _fmode_bin;

int _imphandle (int handle)
{
  int bits, fd, rc, ht;

  if (handle < 0 || handle >= _nfiles)
    {
      errno = EBADF;
      return (-1);
    }

  fd = __imphandle (handle);
  if (fd == -1)
    return (-1);
  if (fd >= _nfiles)
    {
      /* `fd' has been relocated and is now out of range. */

      __dup2 (fd, handle);
      __close (fd);
      errno = EBADF;
      return (-1);
    }

  bits = O_RDWR;                /* TODO */
  if (_fmode_bin == 0)
    bits |= O_TEXT;
  rc = __ioctl1 (fd, 0);
  if (rc != -1 && (rc & 0x80))
    bits |= F_DEV;
  rc = __ioctl2 (fd, FGETHTYPE, (int)&ht);
  if (rc >= 0)
    {
      if (HT_ISDEV (ht))
        bits |= F_DEV;
      if (ht == HT_UPIPE || ht == HT_NPIPE)
        bits |= F_PIPE;
    }

  _files[fd] = bits;
  _lookahead[fd] = -1;
  return (fd);
}
