/* flush.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

int _flush (int c, FILE *stream)
{
  if (!(stream->flags & _IOOPEN) || stream->flush == NULL)
    {
      errno = EACCES;
      return (EOF);
    }
  if (stream->flags & _IOREAD)    /* File in read mode? */
    {
      stream->flags |= _IOERR;
      errno = EACCES;
      return (EOF);
    }
  if (stream->flush (stream, (unsigned char)c) != 0)
    return (EOF);
  return ((unsigned char)c);
}
