/* sys/stat.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <os2emx.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "syscalls.h"

int __stat (const char *name, struct stat *buf)
{
  ULONG rc;
  FILESTATUS3 info;

  memset (buf, 0, sizeof (*buf));
  if ((name[0] == '/' || name[0] == '\\') && strlen (name) >= 6 &&
      memicmp (name+1, "pipe", 4) == 0 && (name[5] == '/' || name[5] == '\\'))
    {
      errno = ENOENT;
      return (-1);
    }
  rc = DosQueryPathInfo (name, FIL_STANDARD, &info, sizeof (info));
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return (-1);
    }
  buf->st_attr = info.attrFile;
  buf->st_reserved = 0;
  buf->st_mtime = _sys_p2t (info.ftimeLastWrite, info.fdateLastWrite);
  if (FTIMEZEROP (info.ftimeCreation) &&
      FDATEZEROP (info.fdateCreation))
    buf->st_ctime = buf->st_mtime;
  else
    buf->st_ctime = _sys_p2t (info.ftimeCreation, info.fdateCreation);
  if (FTIMEZEROP (info.ftimeLastAccess) &&
      FDATEZEROP (info.fdateLastAccess))
    buf->st_atime = buf->st_mtime;
  else
    buf->st_atime = _sys_p2t (info.ftimeLastAccess, info.fdateLastAccess);
  if (info.attrFile & 0x10)     /* directory */
    {
      buf->st_mode = S_IFDIR;
      buf->st_mode |= ((S_IREAD|S_IWRITE|S_IEXEC) >> 6) * 0111;
      buf->st_size = 0;
    }
  else
    {
      buf->st_size = info.cbFile;
      buf->st_mode = S_IFREG;
      if (info.attrFile & 1)
        buf->st_mode |= (S_IREAD >> 6) * 0111;
      else
        buf->st_mode |= ((S_IREAD|S_IWRITE) >> 6) * 0111;
    }
  buf->st_uid = 0;
  buf->st_gid = 0;
  buf->st_ino = _sys_ino++;
  if (_sys_ino == 0)
    _sys_ino = 1;
  buf->st_dev = 0;
  buf->st_rdev = 0;
  buf->st_nlink = 1;
  return (0);
}
