/* omflibap.c (emx+gcc) -- Copyright (c) 1993-1994 by Eberhard Mattes */

/* Add a PUBDEF record to an OMFLIB. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "omflib0.h"
#include <sys/omflib.h>

int omflib_add_pub (struct omflib *p, const char *name, word page, char *error)
{
  int i;

  if (p->pub_count >= p->pub_alloc)
    {
      p->pub_alloc += 32;
      p->pub_tab = realloc (p->pub_tab,
                            p->pub_alloc * sizeof (struct pubsym));
      if (p->pub_tab == NULL)
        {
          strcpy (error, strerror (errno));
          p->pub_alloc = 0;
          p->pub_count = 0;
          return (-1);
        }
    }
  i = p->pub_count;
  if ((p->pub_tab[i].name = strdup (name)) == NULL)
    return (omflib_set_error (error));
  p->pub_tab[i].page = page;
  ++p->pub_count;
  return (0);
}
