/* ulltoa.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <stdlib.h>

char *_ulltoa (unsigned long long value, char *string, int radix)
{
  char *dst;
  char digits[64];
  int i, n;
  
  dst = string;
  if (radix < 2 || radix > 36)
    {
      *dst = 0;
      return (string);
    }
  i = 0;
  do
    {
      n = value % radix;
      digits[i++] = (n < 10 ? (char)n+'0' : (char)n-10+'a');
      value /= radix;
    } while (value != 0);
  while (i > 0)
    *dst++ = digits[--i];
  *dst = 0;
  return (string);
}
