/* ftell.c (emx+gcc) -- Copyright (c) 1990-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>

long ftell (FILE *stream)
{
  long pos;

  if (stream->flags & _IOSPECIAL)
    pos = 0;
  else
    {
      pos = lseek (stream->handle, 0L, SEEK_CUR);
      if (pos < 0)
        return (-1L);
    }
  if (stream->flags & _IOWRT)
    {
      if (bbuf (stream))
        {
          pos += stream->ptr - stream->buffer;
          if (!(stream->flags & _IOSPECIAL)
              && fileno (stream) >= 0 && fileno (stream) < _nfiles
              && _files[fileno (stream)] & O_TEXT)
            {
              const char *p;
              int n;

              /* In text mode, newlines are translated to CR/LF pairs.
                 Adjust the position to take account of this. */

              n = stream->ptr - stream->buffer;
              p = stream->buffer;
              while (n > 0)
                {
                  if (*p ++ == '\n')
                    ++pos;
                  --n;
                }
            }
        }
      /* TODO: text mode */
    }
  else if (stream->flags & _IOREAD)
    {
      /* Subtract the number of unprocessed buffered characters from
         the file postiion of the end of the buffer to get the current
         position. */

      if (!(stream->flags & _IOSPECIAL)
          && fileno (stream) >= 0 && fileno (stream) < _nfiles
          && _files[fileno (stream)] & F_CRLF)
        {
          const char *p;
          int n;

          /* There has been at least one CR/LF to newline translation.
             Assume that all newlines in the buffer have been
             translated from a CR/LF pair each. */

          p = stream->ptr;
          n = stream->rcount;
          if (stream->flags & _IOUNGETC)
            ++p, --n;
          pos -= n;
          while (n > 0)
            {
              if (*p++ == '\n')
                --pos;
              --n;
            }
        }
      else
        {
          /* Binary mode */

          pos -= stream->rcount;
          if (stream->flags & _IOUNGETC)
            ++pos;
        }
    }
  return (pos);
}
