/* egaget.c (emx+gcc) -- Copyright (c) 1994 by Steffen Haecker */

#include <stdlib.h>
#include <sys/hw.h>
#include "graph2.h"
#include "ega.h"


int _ega_get (unsigned x, unsigned y)
{
  int ret;
  unsigned char mask, *p;

  if (x >= _g_clipx0 && x <= _g_clipx1 && y >= _g_clipy0 && y <= _g_clipy1)
    {
      ret = 0;
      mask = 0x80 >> (x & 7);
      p = _g_mem + (y * 80 + x / 8);
      GLOCK;
      OUT1 (0x0304);            /* BITPLANE (3); */
      if (*p & mask)
        ret |= 8;
      BITPLANE (2);
      if (*p & mask)
        ret |= 4;
      BITPLANE (1);
      if (*p & mask)
        ret |= 2;
      BITPLANE (0);
      if (*p & mask)
        ++ret;
      GUNLOCK;
      return (ret);
    }
  else
    return (-1);
}
