/* wmvprint.c (emx+gcc) -- Copyright (c) 1987-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

static int _wm_flush (FILE *stream, int c)
{
  int n;
  wm_handle wh;

  wh = (wm_handle)stream->tmpidx;
  n = stream->ptr - stream->buffer;
  if (n > 0)
    _wm_puts_len (wh, stream->buffer, n);
  stream->ptr = stream->buffer;
  *stream->ptr++ = (char)c;
  stream->wcount = stream->buf_size - 1;
  return (0);
}


int wm_vprintf (wm_handle wh, const char *fmt, va_list arg_ptr)
{
  FILE trick;
  int result;
  char buf[512];

  trick.buffer = buf;
  trick.ptr = buf;
  trick.rcount = 0;
  trick.wcount = sizeof (buf);
  trick.handle = -1;
  trick.flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOWRT;
  trick.buf_size = sizeof (buf);
  trick.flush = _wm_flush;
  trick.tmpidx = (int)wh;
  result = _output (&trick, fmt, arg_ptr);
  _wm_flush (&trick, 0);
  _wm_cursor1 ();
  return (result);
}
