/* vvprintf.c (emx+gcc) -- Copyright (c) 1987-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/video.h>
#include "video2.h"

static int _v_flush (FILE *stream, int c)
{
  int n;

  n = stream->ptr - stream->buffer;
  if (n > 0)
    _v_puts_len (stream->buffer, n);
  stream->ptr = stream->buffer;
  *stream->ptr++ = (char)c;
  stream->wcount = stream->buf_size - 1;
  return (0);
}


int v_vprintf (const char *fmt, va_list arg_ptr)
{
  FILE trick;
  int result;
  char buf[512];

  trick.buffer = buf;
  trick.ptr = buf;
  trick.rcount = 0;
  trick.wcount = sizeof (buf);
  trick.handle = -1;
  trick.flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOWRT;
  trick.buf_size = sizeof (buf);
  trick.flush = _v_flush;
  result = _output (&trick, fmt, arg_ptr);
  _v_flush (&trick, 0);
  return (result);
}
