/* threadlk.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#if defined (__MT__)

#include <sys/emx.h>
#include <stdlib.h>
#define INCL_DOSSEMAPHORES
#define INCL_DOSEXCEPTIONS
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2emx.h>


/* This is required by emxomf to define the symbol. */
__asm__ (".stabs \"__tl_semlist\", 21, 0, 0, 0xffffffff");

extern int _tl_semlist[];


int _tl_init_sem (_tl_sem *psem)
{
  ULONG rc;

  if (_osmode == DOS_MODE)
    return (1);
  rc = DosCreateMutexSem (NULL, psem, 0, FALSE);
  if (rc != 0)
    {
      *psem = 0;
      DosBeep (466, 500);
    }
  return (rc == 0);
}


void _tl_startup (void)
{
  const int *ip;

  if (_osmode == DOS_MODE)
    return;
  ip = &_tl_semlist[0];
  if ((unsigned)*ip < 0x10000)  /* ld */
    ++ip;
  while (*ip != 0)
    {
      if (*ip != -1 && *ip != -2) /* ld, emxomf */
        _tl_init_sem ((_tl_sem *)*ip);
      ++ip;
    }
}


int _tl_lock (_tl_sem sem)
{
  ULONG rc, nesting;

  if (_osmode == DOS_MODE)
    return (1);
  DosEnterMustComplete (&nesting);
  do
    {
      rc = DosRequestMutexSem (sem, SEM_INDEFINITE_WAIT);

      /* ERROR_INTERRUPT cannot occur because signals are held.  Check
         anyway, in case someone removes DosEnterMustComplete. */

    } while (rc == ERROR_SEM_OWNER_DIED || rc == ERROR_INTERRUPT);
  if (rc != 0)
    DosBeep (466, 500);
  return (rc == 0);
}


int _tl_unlock (_tl_sem sem)
{
  ULONG rc, nesting;

  if (_osmode == DOS_MODE)
    return (1);
  rc = DosReleaseMutexSem (sem);
  DosExitMustComplete (&nesting);
  return (rc == 0);
}

#endif /* __MT__ */
