/* defext.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <string.h>

void _defext (char *dst, const char *ext)
{
  int dot, sep;

  dot = FALSE; sep = TRUE;
  while (*dst != 0)
    switch (*dst++)
      {
      case '.':
        dot = TRUE;
        sep = FALSE;
        break;
      case ':':
      case '/':
      case '\\':
        dot = FALSE;
        sep = TRUE;
        break;
      default:
        sep = FALSE;
        break;
      }
  if (!dot && !sep)
    {
      *dst++ = '.';
      strcpy (dst, ext);
    }
}
