/* pipe.c (emx+gcc) -- Copyright (c) 1992-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

int _fmode_bin;
int _pipe_size;

int pipe (int *two_handles)
{
  if (__pipe (two_handles, (_pipe_size != 0 ? _pipe_size : 8192)) != 0)
    return (-1);
  if (two_handles[0] >= _nfiles || two_handles[1] >= _nfiles)
    {
      __close (two_handles[0]);
      __close (two_handles[1]);
      errno = EMFILE;
      return (-1);
    }
  _files[two_handles[0]] = O_RDONLY | F_PIPE;
  _files[two_handles[1]] = O_WRONLY | F_PIPE;
  if (_fmode_bin == 0)
    {
      _files[two_handles[0]] |= O_TEXT;
      _files[two_handles[1]] |= O_TEXT;
    }
  _lookahead[two_handles[0]] = -1;
  _lookahead[two_handles[1]] = -1;
  return (0);
}
