/* pclose.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <process.h>
#include <errno.h>

int pclose (FILE *stream)
{
  int rc, write_mode;

  if (!(stream->flags & _IOOPEN))
    {
      errno = EBADF;
      return (-1);
    }
  write_mode = (stream->flags & _IOWRT);
  if (write_mode && fclose (stream) != 0)
    return (-1);
  if (waitpid (stream->pid, &rc, 0) == -1)
    return (-1);
  if (!write_mode && fclose (stream) != 0 && errno != EBADF)
    return (-1);
  return (rc);
}
