/* newstrea.c (emx+gcc) -- Copyright (c) 1990-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>

#if defined (__MT__)

/* This mutex semaphore protects _streamv[].  Only concurrent access
   by _newstream() in different threads must be prevented to avoid
   using one element of _streamv[] for multiple streams (in different
   threads).  All other functions may concurrently access _streamv[],
   even concurrently to _newstream(). */

_TL_DEFINE_SEM (_stream_mutex)

#define STREAM_LOCK   _tl_lock (_stream_mutex)
#define STREAM_UNLOCK _tl_unlock (_stream_mutex)

#else

#define STREAM_LOCK
#define STREAM_UNLOCK

#endif /* defined (__MT__) */


FILE *_newstream (void)
{
  int i;

  STREAM_LOCK;
  for (i = 0; i < _nfiles; ++i)
    if (!(_streamv[i].flags & _IOOPEN))
      {
        STREAM_UNLOCK;
        return (&_streamv[i]);
      }
  STREAM_UNLOCK;
  return (NULL);
}
