/* mfopen.c (emx+gcc) -- Copyright (c) 1993-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

static int _mflush (FILE *stream, int c)
{
  int n;

  if (c < 0)
    return (0);
  n = stream->ptr - stream->buffer;
  if (n >= stream->buf_size)
    {
      if (stream->tmpidx == 0)
        {
          errno = ENOSPC;
          return (EOF);
        }
      if (stream->tmpidx == -2)
        {
          if (stream->buf_size == 0)
            stream->buf_size = 512;
          else
            stream->buf_size *= 2;
        }
      else
        stream->buf_size += stream->tmpidx;
      stream->buffer = realloc (stream->buffer, stream->buf_size);
      if (stream->buffer == NULL)
        {
          stream->buf_size = 0;
          stream->wcount = 0;
          errno = ENOMEM;
          return (EOF);
        }
    }
  stream->ptr = stream->buffer + n;
  *stream->ptr++ = (char)c;
  ++n;
  stream->wcount = stream->buf_size - n;
  return (0);
}



FILE *_mfopen (char *buf, const char *mode, size_t size, int inc)
{
  FILE *stream;

  if (mode[0] != 'w' || mode[1] != 'b' || mode[2] != 0)
    {
      errno = EINVAL;
      return (NULL);
    }
  if ((buf == NULL && inc == 0) || (buf != NULL && (size == 0 || inc != 0)))
    {
      errno = EINVAL;
      return (NULL);
    }
  stream = _newstream ();
  if (stream == NULL)
    return (NULL);
  if (buf == NULL && size != 0)
    {
      buf = malloc (size);
      if (buf == NULL)
        {
          stream->flags = 0;
          errno = ENOMEM;
          return (NULL);
        }
    }
  stream->buffer = buf;
  stream->ptr = buf;
  stream->rcount = 0;
  stream->wcount = size;
  stream->handle = -1;
  stream->flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOWRT;
  stream->buf_size = size;
  stream->flush = _mflush;
  stream->tmpidx = inc;
  stream->_ungetc_count = 0;
  return (stream);
}


char *_mfclose (FILE *stream)
{
  if ((stream->flags & (_IOOPEN|_IOSPECIAL)) != (_IOOPEN|_IOSPECIAL)
      || stream->flush != _mflush)
    return (NULL);
  stream->flags = 0;
  return (stream->buffer);
}
