/* stdio.h (emx+gcc) */

#if !defined (_STDIO_H)
#define _STDIO_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (BUFSIZ)
#define BUFSIZ 5120
#endif

#if !defined (_FILE_T)
#define _FILE_T
struct _FILE
{
  char * ptr;
  char * buffer;
  int    rcount;
  int    wcount;
  int    handle;
  int    flags;
  int    buf_size;
  int    tmpidx;
  int    pid;
  char   char_buf;
  unsigned char _ungetc_count;
  char   _reserved1[2];
  int    (*flush)(struct _FILE *f, int c);
  unsigned long sem;
};

typedef struct _FILE FILE;

extern FILE _streamv[];

#define stdin  (&_streamv[0])
#define stdout (&_streamv[1])
#define stderr (&_streamv[2])

#endif

#if !defined (SEEK_SET)
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#if !defined (EOF)
#define EOF (-1)
#endif

#if !defined (_IOREAD)
#define _IOREAD 0x01
#define _IOWRT  0x02
#define _IORW   0x04
#define _IOEOF  0x08
#define _IOERR  0x10
#define _IOFBF  0x00
#define _IOLBF  0x20
#define _IONBF  0x40
#endif

#if !defined (FOPEN_MAX)
#define	FOPEN_MAX       14
#endif

#if !defined (FILENAME_MAX)
#define	FILENAME_MAX    260
#endif

#if !defined (TMP_MAX)
#define TMP_MAX         1000
#endif

#if !defined (P_tmpdir)
#define P_tmpdir "."
#define L_tmpnam (sizeof (P_tmpdir) + 13)
#endif

#if !defined (L_cuserid)
#define L_cuserid       9
#endif

#if !defined (_FPOS_T)
#define _FPOS_T
typedef long fpos_t;
#endif

#if !defined (_VA_LIST)
#define _VA_LIST
typedef char *va_list;
#endif

void clearerr (FILE *stream);
int fclose (FILE *stream);
FILE *fdopen (int handle, __const__ char *mode);
int fflush (FILE *stream);
int fgetc (FILE *stream);
int fgetpos (FILE *stream, fpos_t *pos);
char *fgets (char *buffer, int n, FILE *stream);
FILE *fopen (__const__ char *fname, __const__ char *mode);
int fprintf (FILE *stream, __const__ char *format, ...);
int fputc (int c, FILE *stream);
int fputs (__const__ char *string, FILE *stream);
size_t fread (void *buffer, size_t size, size_t count, FILE *stream);
FILE *freopen (__const__ char *fname, __const__ char *mode, FILE *stream);
int fscanf (FILE *stream, __const__ char *format, ...);
int fseek (FILE *stream, long offset, int origin);
int fsetpos (FILE *stream, __const__ fpos_t *pos);
long ftell (FILE *stream);
size_t fwrite (__const__ void *buffer, size_t size, size_t count,
    FILE *stream);
char *gets (char *buffer);
void perror (__const__ char *string);
int printf (__const__ char *format, ...);
int puts (__const__ char *string);
int remove (__const__ char *name);
int rename (__const__ char *old_name, __const__ char *new_name);
void rewind (FILE *stream);
int scanf (__const__ char *format, ...);
int setbuf (FILE *stream, char *buffer);
int setvbuf (FILE *stream, char *buffer, int mode, size_t size);
int sprintf (char *buffer, __const__ char *format, ...);
int sscanf (__const__ char *buffer, __const__ char *format, ...);
FILE *tmpfile (void);
char *tmpnam (char *string);
int ungetc (int c, FILE *stream);
int vfprintf (FILE *stream, __const__ char *format, va_list arg_ptr);
int vfscanf (FILE *stream, __const__ char *format, va_list arg_ptr);
int vprintf (__const__ char *format, va_list arg_ptr);
int vscanf (__const__ char *format, va_list arg_ptr);
int vsprintf (char *buffer, __const__ char *format, va_list arg_ptr);
int vsscanf (__const__ char *buffer, __const__ char *format, va_list arg_ptr);

#if !defined (_POSIX_SOURCE)

char *cuserid (char *buffer);
int getw (FILE *stream);
int fcloseall (void);
int fgetchar (void);
int flushall (void);
int fputchar (int c);
int pclose (FILE *stream);
FILE *popen (__const__ char *command, __const__ char *mode);
int putw (int x, FILE *stream);
int setbuffer (FILE *stream, char *buffer, size_t size);
char *tempnam (__const__ char *dir, __const__ char *prefix);

#endif

int _fill (FILE *stream);
int _flush (int c, FILE *stream);
int _fsetmode (FILE *stream, __const__ char *mode);
char *_mfclose (FILE *stream);
FILE *_mfopen (char *buf, __const__ char *mode, size_t size, int inc);
int _fseek_hdr (FILE *stream);
FILE *_fsopen (__const__ char *fname, __const__ char *mode, int shflag);
int _rmtmp (void);

static __inline__ int fileno (FILE *s) { return (s->handle); }
static __inline__ int feof (FILE *s) { return (s->flags & _IOEOF ? 1 : 0); }
static __inline__ int ferror (FILE *s) { return (s->flags & _IOERR ? 1 : 0); }

#if defined (__MT__)

#define getc(s)   fgetc(s)
#define putc(c,s) fputc(c,s)

#else

static __inline__ int getc (FILE *s)
{
  return (--s->rcount >= 0
          ? (unsigned char)*s->ptr++
          : _fill (s));
}

static __inline__ int putc (int c, FILE *s)
{
  return (--s->wcount >= 0 && (c != '\n' || !(s->flags & _IOLBF))
          ? (unsigned char)(*s->ptr++ = (char)c)
          : _flush (c, s));
}

#endif

static __inline__ int getchar (void) { return (getc (stdin)); }
static __inline__ int putchar (int c) { return (putc (c, stdout)); }

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_STDIO_H) */
