/* chdir2.c (emx+gcc) -- Copyright (c) 1992-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>

int _chdir2 (const char *name)
{
  char old_drive, new_drive, *tmp;
  int i, saved_errno;

  i = strlen (name);
  if (i > 1 && (name[i-1] == '\\' || name[i-1] == '/') &&
      (name[i-2] != '\\' && name[i-2] != '/' && name[i-2] != ':'))
    {
      tmp = alloca (i);
      memcpy (tmp, name, i);
      tmp[i-1] = 0;
      name = tmp;
    }
  old_drive = _getdrive ();
  new_drive = _fngetdrive (name);
  if (new_drive != 0)
    {
      if (_chdrive (new_drive) != 0)
        return (-1);
      if (name[2] == 0)         /* Change drive only */
        return (0);
    }
  if (__chdir (name) == 0)
    return (0);
  else
    {
      saved_errno = errno;
      _chdrive (old_drive);
      errno = saved_errno;
      return (-1);
    }
}
