diff -ur --new-file v101qc/items.qc eatgibs/items.qc
--- v101qc/items.qc     Wed Jul 24 23:51:22 1996
+++ eatgibs/items.qc	Tue Aug  6 20:07:44 1996
@@ -1338,3 +1338,55 @@
 	item.nextthink = time + 120;	// remove after 2 minutes
 	item.think = SUB_Remove;
 };
+
+void() EatGibs =
+{
+// only a player can pick it up
+        if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+// only eat gibs if desparate
+        if (other.health >= 50)
+                return;
+
+// heal a random amount of 10% health
+        if (!T_Heal(other, random() * 10, 0))
+                return;
+
+        sprint(other, "Yummy gibs!\n");
+
+// gibs touch sound
+	sound(other, CHAN_ITEM, "zombie/z_miss.wav", 1, ATTN_NORM);
+
+        stuffcmd (other, "bf\n");
+
+        remove (self);
+
+};
+
+void() EatHead =
+{
+// only a player can pick it up
+        if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+// only eat head if desparate
+        if (other.health >= 50)
+                return;
+
+// heal 15%
+        if (!T_Heal(other, 15, 0))
+                return;
+
+        sprint(other, "Tasty brains!\n");
+
+// head touch sound
+        sound(other, CHAN_ITEM, "demon/dhit2.wav", 1, ATTN_NORM);
+
+        stuffcmd (other, "bf\n");
+
+        remove (self);
+
+};
diff -ur --new-file v101qc/player.qc eatgibs/player.qc
--- v101qc/player.qc    Wed Jul 24 23:51:22 1996
+++ eatgibs/player.qc	Tue Aug  6 16:48:50 1996
@@ -466,7 +466,7 @@
 	setsize (new, '0 0 0', '0 0 0');
 	new.velocity = VelocityForDamage (dm);
 	new.movetype = MOVETYPE_BOUNCE;
-	new.solid = SOLID_NOT;
+        new.solid = SOLID_TRIGGER;
 	new.avelocity_x = random()*600;
 	new.avelocity_y = random()*600;
 	new.avelocity_z = random()*600;
@@ -475,6 +475,7 @@
 	new.nextthink = time + 10 + random()*10;
 	new.frame = 0;
 	new.flags = 0;
+        new.touch = EatGibs;
 };
 
 void(string gibname, float dm) ThrowHead =
@@ -484,13 +485,14 @@
 	self.nextthink = -1;
 	self.movetype = MOVETYPE_BOUNCE;
 	self.takedamage = DAMAGE_NO;
-	self.solid = SOLID_NOT;
+        self.solid = SOLID_TRIGGER;
 	self.view_ofs = '0 0 8';
 	setsize (self, '-16 -16 0', '16 16 56');
 	self.velocity = VelocityForDamage (dm);
 	self.origin_z = self.origin_z - 24;
 	self.flags = self.flags - (self.flags & FL_ONGROUND);
 	self.avelocity = crandom() * '0 600 0';
+        self.touch = EatHead;
 };
 
 
diff -ur --new-file v101qc/world.qc eatgibs/world.qc
--- v101qc/world.qc     Wed Jul 24 23:51:24 1996
+++ eatgibs/world.qc	Tue Aug  6 20:10:30 1996
@@ -190,7 +190,10 @@
 	precache_sound ("misc/h2ohit1.wav");		// landing splash
 
 // setup precaches allways needed
-	precache_sound ("items/itembk2.wav");		// item respawn sound
+        precache_sound ("demon/dhit2.wav");             // for eatin' heads
+        precache_sound ("zombie/z_miss.wav");           // for eatin' gibs
+
+        precache_sound ("items/itembk2.wav");           // item respawn sound
 	precache_sound ("player/plyrjmp8.wav");		// player jump
 	precache_sound ("player/land.wav");			// player landing
 	precache_sound ("player/land2.wav");		// player hurt landing
