/*
==============================================================================

TM BOT HEADER FILE

==============================================================================
*/

// Global Constants

float   BOT_TOGGLE				= 100;		// impulse constant
float	BOT_AUTO_TOGGLE			= 101;		// impulse constant
float	BOT_MOVE_FIRE			= 102;		// impulse constant
float 	BOT_LEFT_FIRE_TOGGLE	= 103;		// impulse constant
float	BOT_RIGHT_TELEPORT		= 104;		// impulse constant
float	STAND					= 0;		// move_flag constant
float	WALK					= 1;		// move_flag constant
float	RUN						= 2;		// move_flag constant

// Bot Prototypes - called by player

void () Bot_Precache;		// Precache information for the bot
void () BotActivate;		// Activate bot
void () BotDeActivate;		// DeActivate bot
void () BotToggle;			// Toggle bot on and off
void () BotAutoToggle;		// Toggle automatic/manual control of bot
void () BotMoveToggle;		// Toggle movement (walk, run, stand) in man mode
void ()	BotTurnRight;		// Turn bot to the right by 22.5 degrees in man mode
void () BotTurnLeft;		// Turn bot to the left by 22.5 degrees in man mode
void () BotFireToggle;		// Toggle bot's auto-firing in auto mode
void ()	BotFire;			// Have bot fire at its current target in auto mode
void ()	BotTeleportHome;	// Have bot teleport back to its owner

// Botai Prototypes - called by bot (mostly modified versions of existing code)

float	()								BotFindTarget;
void	()								BotFoundTarget;
void	()								BotSightSound;
void	()								BotHuntTarget;
void	()								bot_ai_stand;
void	(float dist)					bot_ai_walk;
void	(float dist)					man_bot_ai_walk;	// Manual mode ai_walk
void	(float dist)					bot_ai_run;
void	(float dist)					man_bot_ai_run;		// Manual mode ai_run
void	(float dist)					bot_ai_follow;
void	(entity attacker, float damage)	bot_pain;
void	()								bot_die;
void	()								bot_ai_turn;
void	()								bot_fire;
void	(void () thinkst)				BotCheckRefire;		// Replaces SUB_CheckRefire
void	()								BotSelfDeActivate;

// Bot_ext Prototypes - called by triggers.qc

void	()		bot_counter_use;
void	()		bot_trigger_onlyregistered_touch;

//	Addition entity fields
//	.entity		bot;		// bot entity
//	.float		bot_flag;	// existence of bot (TRUE or FALSE)
//	.float		bot_auto;	// flags auto mode of bot (TRUE or FALSE)
//	.float		move_flag;	// (STAND, WALK, OR RUN)
//	.float		auto_fire	// (TRUE or FALSE)
