# This is a comment line
# Line starts with ! is a command line

# !!! Warning : The effects of commands are ACCUMULATED.

# This file contains all commands known by DISPLAY.
# This file is for documentation. Copy it to another file and use that file
#   to generate conatc sheet.

# If you load this file within DISPLAY, The settings in this file will
# override the current settings in DISPLAY.

# this is identifier
batch_contact_sheet

# all lines between !neglect_begin and !neglect_end are ignored, including
# command lines and image file names.
# A !neglect_end without the corresponding !neglect_begin is ignored.
#!neglect_begin
#!neglect_end

# whole contact sheet size. Default is in config.dis
# min value is 32.
#!sheet_width 800
#!sheet_height 600

# contact sheet work space offset and size. These four parameters define
# a rectangle for contact sheet making. work space must <= whole size.
# offset starts from 0. Default is in config.dis.
# work size can be 0 or >= 32. 0 means using whole contact sheet.
# If you set work space, DISPLAY doesn't trim contact sheet.
#!sheet_work_offset_x 0
#!sheet_work_offset_y 0
#!sheet_work_width 0
#!sheet_work_height 0

# method. choose one. Default is in config.dis
#!variable_box_size
#!fixed_box_size
#!fixed_box_width
#!fixed_box_height

# for fixed_box_* method. Default is in config.dis
# min value is 8.
#!box_width 80
#!box_height 80

# for variable_box_size method only. Default is in config.dis
# min value is 8.
#!image_min_width 8
#!image_min_height 8

# Pack as many boxes as possible in single sheet. For all methods.
# Default is no. 'max_pack' overrides 'number_image'.
# Useful for wild card file name.
# Note : If you use max_pack with variable_box_size method, be sure to set
#        the image_min_width & image_min_height to reasonable value.
#!max_pack
#!no_max_pack

# Default number of images in single sheet. Default is none, that is,
# sheet is generated only when 'generate' appears. 0 = none.
# Useful for wild card file name.
#!number_image 0

# Try to produce contact sheet every threshold_number images. Works for
# 'max_pack' and 'number_image' only. 0 = none. Default is none.
# useful for wild card file name. Use less memory.
#!threshold_number 0

# Whether generate .idx file or not. Please read DISPLAY.DOC for the
# purpose of .idx file. Default is no_index.
#!index
#!no_index

# Draw frame around image or not. Default is in config.dis.
#!frame_around
#!no_frame_around

# Contact sheet colors. Defaults are in config.dis.
# Order: Red,Green,Blue. Range: 0 -- 255.
#!background_color 200,200,255
#!string_color 0,0,0
#!title_color 0,0,255
#!frame_color 0,0,0

# Background image name. Default is None.
#!background c:\image\jpg\back.jpg

# Background image arrangement: center, repeat, none. 
# Default is in config.dis.
# 'none' means set background image to none.
#!bg_arrange center

# Show text string background color. Default is in config.dis
#!show_text_back
#!no_show_text_back

# string options: print image name & dimension or user-input strings.
# Default is name_dimension.
#!name_dimension
#!user_input

# text display options (for string options above).
# 0 : Filename only  / user string1.
# 1 : Filename & Dim. / user string1 & user string2.
# 2 : Dimension only / user string2.
# 3 : None. 
# default is in config.dis.
#!text_option 1

# Sort image by : none, name, height, width.
# default is in config.dis.
#!sort_by none

# Auto adjust image location or not. Default is in config.dis.
#!auto_adjust
#!no_auto_adjust

# Auto trim the unused space at the contact sheet bottom.
# Default is in config.dis.
#!auto_trim
#!no_auto_trim

# Fonts for title & string. Default is in config.dis.
# You can't include path in the font name. DISPLAY searches font_path for
# fonts.
#!string_font pc8x16.fnt
#!title_font pc8x16.fnt

# output format (standard extension). Default is JPG.
#!format jpg
# output color type : bw, grey, color, true. Default is true(truecolor).
#!color_type true

# choose exact file name or template. Default is exact file name.

# exact output file name. max 8 chars. Default is "contact"
#!output_file contact

# output file template. generates sheet001, sheet002, sheet003 ...
# max 7 chars. Default is "contact"
#!output_template sheet
# Default is 1
#!template_counter_start 1

# input/output directory. Default is current directory.
#!input_dir
#!output_dir

# Use 4DOS description file as contact sheet title. Default description 
# filename is in config.dis. If 'input_dir' is "c:/aaa/bbb/ccc", DISPLAY
# searches the description file in "c:/aaa/bbb" for "ccc" entry and uses the 
# description for as 'title'. If not found, 'title' is unchange.
# every time you change the 'input_dir', 'title' is changed, too.
# default is no.
#!title_desc

# contact sheet title (up to 49 chars). Default is in config.dis.
# This command disables the '!title_desc' command.
#!title This is contact sheet title

# input image files.
# If file name contains path(e.g. c:/image/aaaa.gif or ../bbbb.jpg), it is
#   used as is, that is, 'input_dir' is ignored. Otherwise 'input_dir' is
#   assumed.
# If you start 'batch contact sheet' from within DISPLAY, you can use 
#   '!use_tagged' command to add the tagged files to file list. It is useless
#   for command-line batch contact sheet making.
# Wild card is allowed. See MATCH.DOC for the wild card match.
# Notes:
#   don't use '\' in wild card, though it is allowed in filename mask.
#   wild card files are sorted by file name.
#   DISPLAY completes each wild card processing before making contact sheet. 
#     So if you use wild card, be sure that you have enough memory to build
#     the filename list.

#!use_tagged
a:/image/aaaa.gif
../bbbb.jpg
cccc.bmp
dddd.rle
*.gif
#        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#        you can write 2 'user input' strings after image name.
#        Each up to 49 chars.
#        Please read DISPLAY.FAQ for more information.

# generate contact sheet or ignore above images
# 'genrate' and 'ignore' advance the template counter.
!generate
#!ignore

# you can change any command and generate another contact sheet.

!input_dir c:/qqq/rrr

eeee.gif
ffff.gif
hhhh.gif
yyyy.gif

# generate 2nd contact sheet
!generate
