#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <mem.h>
#include <dos.h>
#include <stdlib.h>

#define FALSE  0
#define TRUE   1
#define TRANS  0
#define LEFT   1
#define RIGHT  2
#define TOP    4
#define BOTTOM 8
#define MAXFRAMES 5
#define BYTE   unsigned char
#define WORD   unsigned int

char far *screen=(char far *) 0xA0000000;
char far *dblbuf=(char far *) farmalloc(64000);

class animation {
  unsigned char curframe;
  unsigned int x;
  unsigned int y;
  unsigned int xsize;
  unsigned int ysize;
  signed char xspeed;
  signed char yspeed;
public:
  unsigned char framedel;
  unsigned char framectr;
  unsigned char loop;
  char far *objptr;
  char far *orgptr;
  char far *frame[MAXFRAMES];

  animation();
  destruct();

  void show();
  void hide();
  void next()      { x+=xspeed; y+=yspeed; }
  void link(unsigned char framenum) {  orgptr=frame[framenum]; }
  void animate();
  void animove();
  void allocback(int a, int b);
  void onscreen();

  void setloc(int a, int b)   { x=a; y=b; }
  void setsize(int a, int b)  { xsize=a; ysize=b; }
  void setspeed(int a, int b) { xspeed=a; yspeed=b; }
  void setframe(int num)      { curframe=num; }

  int getspritecol(animation *s);
  int getcolstatus();
  int getx()       { return(x); }
  int gety()       { return(y); }
  int getxspeed()  { return(xspeed); }
  int getyspeed()  { return(yspeed); }
  int getxsize()   { return(xsize); }
  int getysize()   { return(ysize); }
  int getframe()   { return(curframe); }

  void loadobj(char *);
  void error(int erno);
};

animation::animation() {
  unsigned int c;

  curframe=framectr=0;
  framedel=1;
  x=y=xsize=ysize=0;
  xspeed=yspeed=loop=0;
  objptr=orgptr=NULL;
  for(c=0; c<MAXFRAMES; c++)
    frame[c]=NULL;
}

animation::destruct() {
  unsigned int c;

  farfree(objptr);
  objptr=NULL;
  for(c=0; c<MAXFRAMES; c++) {
    farfree(frame[c]);
    frame[c]=NULL;
  }
  return(0);
}


void animation::show() {
  unsigned int aa, bb, o0;

  for(aa = y*320+x, o0=0; aa < y*320+x + ysize*320; aa += 320)
    for(bb = 0; bb<xsize; bb++, o0++)
      if(orgptr[o0] != TRANS) {
	objptr[o0]=dblbuf[aa+bb];
	dblbuf[aa+bb]=orgptr[o0];
      }
}

void animation::hide() {
  unsigned int aa, bb, o0;

  for(aa = y*320+x, o0=0; aa < y*320+x + ysize*320; aa += 320)
    for(bb = 0; bb<xsize; bb++, o0++)
      if(orgptr[o0] != TRANS)
	dblbuf[aa+bb]=objptr[o0];
}

void animation::animate() {
  framectr++;
  if(framectr == framedel) {
    framectr=0; curframe++;
    if(frame[curframe] == NULL || curframe == MAXFRAMES) {
      if(loop == TRUE)
	curframe=0;
      else
	curframe--;
    }
    link(curframe);
  }
}

void animation::animove() {
  framectr++;
  if(framectr == framedel) {
    framectr=0; curframe++;
    if(frame[curframe] == NULL || curframe == MAXFRAMES) {
      if(loop == TRUE)
	curframe = 0;
      else
	curframe--;
    }
    hide();
    x+=xspeed; y+=yspeed;
    link(curframe); show();
  } else {
    hide();
    x+=xspeed; y+=yspeed;
    show();
  }
}

void animation::allocback(int a, int b) {
  xsize=a; ysize=b;
  objptr=(char far *)farmalloc(xsize*ysize);
  if(objptr==NULL) error(1);
}

void animation::onscreen() {
  while(inportb(0x03DA)&8!=0);
  while(inportb(0x03DA)&8==0);
  asm {
    push ds
    les  di,[screen]
    lds  si,[dblbuf]
    mov  cx,16000              //64000/4
    db   0x66
    rep  movsw
    pop  ds
  }
}

int animation::getspritecol(animation *s) {
  unsigned short xx, yy;
  unsigned int dx=x+xspeed-(s->getx() + s->getxspeed());   // abs()
  unsigned int dy=y+yspeed-(s->gety() + s->getyspeed());   // abs()

  if(abs(dx) > xsize && abs(dx) > s->getxsize()) return(FALSE);
  if(abs(dy) > ysize && abs(dy) > s->getysize()) return(FALSE);
  for(yy=0; yy<ysize; yy++) for(xx=0; xx<xsize; xx++)
    if(yy-dy < s->getysize() && xx-dx < s->getxsize())
      if(orgptr[yy*ysize+xx] != TRANS && s->orgptr[yy*s->getysize()+xx] != TRANS)
	return(TRUE);
  return(FALSE);
}

int animation::getcolstatus() {
  unsigned int collision=FALSE;

  if(x<0-xspeed && xspeed<0) collision=LEFT;
  if(x+xsize>319-xspeed && xspeed>0) collision=RIGHT;
  if(y<0-yspeed && yspeed<0) collision=TOP;
  if(y+ysize>199-yspeed && yspeed>0) collision=BOTTOM;
  return(collision);
}

void animation::loadobj(char *tiednimi) {
  int a,b;
  FILE *handle=fopen(tiednimi,"rb");

  if(handle == NULL) error(2);
  xsize=fgetc(handle) << 8;
  xsize+=fgetc(handle);
  ysize=fgetc(handle) << 8;
  ysize+=fgetc(handle);
  frame[curframe]=(char far *)farmalloc(xsize*ysize);
  if(frame[curframe] == NULL) error(3);
  for(a=0; a<xsize; a++)
    for(b=0; b<ysize; b++)
      frame[curframe][b*xsize+a]=fgetc(handle);
  fclose(handle);
  curframe++;
}

void animation::error(int erno) {
  getch();
  textmode(0x03);
  printf("Errornumber is: %d",erno);
  printf("%d %d",xsize, ysize);
  exit(erno);
}
