
(*
   CapaPlay II Unit for Pascal

   Don't forget to add the {$M stacksize,0,0} into your program header!
*)

{$G+}
unit capapla2;

interface

(****************************** GUS Settings *********************************)

function CP_GetIRQ:byte; far;
procedure CP_SetIRQ(NewIRQ:byte); far;
function CP_GetDMA:byte; far;
procedure CP_SetDMA(NewDMA:byte); far;
function CP_GetBasePort:word; far;
procedure CP_SetBasePort(NewBasePort:word); far;
procedure CP_SetLineIn(LineInState:byte); far;
procedure CP_SetMicIn(MicInState:byte); far;

(******************************* Load/Unload *********************************)

function CP_LoadModule(ModName:string;StartOffset:longint;TransferMode:byte):byte; far;
function CP_LoadOnlyPatterns(ModName:string;StartOffset:longint;TransferMode:byte):byte; far;
procedure CP_FreeModule; far;

(***************************** Start/Stop/Pause ******************************)

procedure CP_StartModule(Amplification:byte;DefaultPanning:byte;TimerMode:byte); far;
procedure CP_StopModule; far;
function CP_PauseModule:byte; far;

(********************** Set General Module Information ***********************)

procedure CP_SetSpeedZeroMode(SpeedZeroMode:byte); far;
procedure CP_SetPanEffectMode(PanEffectMode:byte); far;
procedure CP_SetVBlankMode(VBlankMode:byte); far;
procedure CP_SetAmigaLimitsMode(AmigaLimitsMode:byte); far;

(********************** Get General Module Information ***********************)

function CP_GetModuleName:string; far;
function CP_GetModuleType:byte; far;
function CP_GetModuleLength:byte; far;
function CP_GetNumOfPatterns:word; far;
function CP_GetNumOfInstruments:byte; far;
function CP_GetNumOfChannels:byte; far;
function CP_GetNumOfUsedChannels:byte; far;
function CP_GetRestartPosition:byte; far;
function CP_GetUsedPatternMemory:longint; far;
function CP_GetUsedInstrumentInfoMemory:longint; far;
function CP_GetUsedGUSMemory:longint; far;
function CP_GetFileSize:longint; far;

(********************** Set General Playing Information **********************)

procedure CP_SetPosition(NewPosition:word); far;
procedure CP_SetGlobalVolume(NewVolume:word); far;
procedure CP_SetMainVolume(NewVolume:word); far;
procedure CP_SetSpeed(NewSpeed:word); far;
procedure CP_SetTempo(NewTempo:word); far;
procedure CP_RestoreSpeedAndTempo; far;
procedure CP_SetDefaultPanning(DefaultPanning:shortint); far;

(********************** Get General Playing Information **********************)

function CP_GetRow:byte; far;
function CP_GetNumOfRows(PositionNum:word):word; far;
function CP_GetPosition:byte; far;
function CP_GetPattern:byte; far;
function CP_GetGlobalVolume:byte; far;
procedure CP_RestoreInitialVolume; far;
function CP_GetMainVolume:byte; far;
function CP_GetSpeed:byte; far;
function CP_GetTempo:byte; far;
function CP_GetPlayingTime:word; far;
function CP_GetTimer:longint; far;
function CP_GetLoopCounter:byte; far;

(************************* Set Channel Information ***************************)

function CP_SetChannelMute(ChannelNum:word;MuteState:byte):byte; far;
procedure CP_SetChannelPanning(ChannelNum:word;NewPanning:byte); far;
procedure CP_PlaySample(ChannelNum:word;InstrumentNum:word;SampleNum:word;Note:byte;Octave:byte); far;
procedure CP_StopSample(ChannelNum:word); far;

(************************* Get Channel Information ***************************)

function CP_GetChannelNote(ChannelNum:word):byte; far;
function CP_GetChannelOctave(ChannelNum:word):byte; far;
function CP_GetChannelVolume(ChannelNum:word):byte; far;
function CP_GetChannelEffect(ChannelNum:word):byte; far;
function CP_GetChannelEffectParams(ChannelNum:word):byte; far;
function CP_GetChannelInstrument(ChannelNum:word):byte; far;
function CP_GetChannelSample(ChannelNum:word):byte; far;
function CP_GetChannelBar(ChannelNum:word):byte; far;
function CP_GetChannelNoteTrigger(ChannelNum:word):byte; far;
function CP_GetChannelPanning(ChannelNum:word):byte; far;
function CP_GetChannelMute(ChannelNum:word):byte; far;

(******************** Set Instrument/Sample Information **********************)

function CP_SetSampleMute(InstrumentNum:word;SampleNum:word;MuteState:byte):byte; far;

(******************** Get Instrument/Sample Information **********************)

function CP_GetInstrumentName(InstrumentNum:word):string; far;
function CP_GetNumOfSamples(InstrumentNum:word):byte; far;
function CP_GetSampleName(InstrumentNum:word;SampleNum:word):string; far;
function CP_GetSampleSize(InstrumentNum:word;SampleNum:word):longint; far;
function CP_GetSampleC4Spd(InstrumentNum:word;SampleNum:word):word; far;
function CP_GetSampleVolume(InstrumentNum:word;SampleNum:word):byte; far;
function CP_GetSamplePanning(InstrumentNum:word;SampleNum:word):byte; far;
function CP_GetSampleLoopType(InstrumentNum:word;SampleNum:word):byte; far;
function CP_GetSampleLoopBegin(InstrumentNum:word;SampleNum:word):longint; far;
function CP_GetSampleLength(InstrumentNum:word;SampleNum:word):longint; far;
function CP_GetSample16Bit(InstrumentNum:word;SampleNum:word):byte; far;
function CP_GetSampleMute(InstrumentNum:word;SampleNum:word):byte; far;

implementation

function _CP_GetIRQ:byte; far; external;
procedure _CP_SetIRQ(NewIRQ:byte); far; external;
function _CP_GetDMA:byte; far; external;
procedure _CP_SetDMA(NewDMA:byte); far; external;
function _CP_GetBasePort:word; far; external;
procedure _CP_SetBasePort(NewBasePort:word); far; external;
procedure _CP_SetLineIn(LineInState:byte); far; external;
procedure _CP_SetMicIn(MicInState:byte); far; external;
function _CP_LoadModule(TransferMode:byte;StartOffset:longint;ModSeg:word;ModOfs:word):byte; far; external;
function _CP_LoadOnlyPatterns(TransferMode:byte;StartOffset:longint;ModSeg:word;ModOfs:word):byte; far; external;
procedure _CP_FreeModule; far; external;
procedure _CP_StartModule(TimerMode:byte;DefaultPanning:byte;Amplification:byte); far; external;
procedure _CP_StopModule; far; external;
function _CP_PauseModule:byte; far; external;
procedure _CP_SetSpeedZeroMode(SpeedZeroMode:byte); far; external;
procedure _CP_SetPanEffectMode(PanEffectMode:byte); far; external;
procedure _CP_SetVBlankMode(VBlankMode:byte); far; external;
procedure _CP_SetAmigaLimitsMode(AmigaLimitsMode:byte); far; external;
function _CP_GetModuleName:longint; far; external;
function _CP_GetModuleType:byte; far; external;
function _CP_GetModuleLength:byte; far; external;
function _CP_GetNumOfPatterns:word; far; external;
function _CP_GetNumOfInstruments:byte; far; external;
function _CP_GetNumOfChannels:byte; far; external;
function _CP_GetNumOfUsedChannels:byte; far; external;
function _CP_GetRestartPosition:byte; far; external;
function _CP_GetUsedPatternMemory:longint; far; external;
function _CP_GetUsedInstrumentInfoMemory:longint; far; external;
function _CP_GetUsedGUSMemory:longint; far; external;
function _CP_GetFileSize:longint; far; external;
procedure _CP_SetPosition(NewPosition:word); far; external;
procedure _CP_SetGlobalVolume(NewVolume:word); far; external;
procedure _CP_SetMainVolume(NewVolume:word); far; external;
procedure _CP_SetSpeed(NewSpeed:word); far; external;
procedure _CP_SetTempo(NewTempo:word); far; external;
procedure _CP_RestoreSpeedAndTempo; far; external;
procedure _CP_SetDefaultPanning(DefaultPanning:shortint); far; external;
function _CP_GetRow:byte; far; external;
function _CP_GetNumOfRows(PositionNum:word):word; far; external;
function _CP_GetPosition:byte; far; external;
function _CP_GetPattern:byte; far; external;
function _CP_GetGlobalVolume:byte; far; external;
procedure _CP_RestoreInitialVolume; far; external;
function _CP_GetMainVolume:byte; far; external;
function _CP_GetSpeed:byte; far; external;
function _CP_GetTempo:byte; far; external;
function _CP_GetPlayingTime:word; far; external;
function _CP_GetTimer:longint; far; external;
function _CP_GetLoopCounter:byte; far; external;
function _CP_SetChannelMute(MuteState:byte;ChannelNum:word):byte; far; external;
procedure _CP_SetChannelPanning(NewPanning:byte;ChannelNum:word); far; external;
procedure _CP_PlaySample(Octave:byte;Note:byte;SampleNum:word;InstrumentNum:word;ChannelNum:word); far; external;
procedure _CP_StopSample(ChannelNum:word); far; external;
function _CP_GetChannelNote(ChannelNum:word):byte; far; external;
function _CP_GetChannelOctave(ChannelNum:word):byte; far; external;
function _CP_GetChannelVolume(ChannelNum:word):byte; far; external;
function _CP_GetChannelEffect(ChannelNum:word):byte; far; external;
function _CP_GetChannelEffectParams(ChannelNum:word):byte; far; external;
function _CP_GetChannelInstrument(ChannelNum:word):byte; far; external;
function _CP_GetChannelSample(ChannelNum:word):byte; far; external;
function _CP_GetChannelBar(ChannelNum:word):byte; far; external;
function _CP_GetChannelNoteTrigger(ChannelNum:word):byte; far; external;
function _CP_GetChannelPanning(ChannelNum:word):byte; far; external;
function _CP_GetChannelMute(ChannelNum:word):byte; far; external;
function _CP_SetSampleMute(MuteState:byte;SampleNum:word;InstrumentNum:word):byte; far; external;
function _CP_GetInstrumentName(InstrumentNum:word):longint; far; external;
function _CP_GetNumOfSamples(InstrumentNum:word):byte; far; external;
function _CP_GetSampleName(SampleNum:word;InstrumentNum:word):longint; far; external;
function _CP_GetSampleSize(SampleNum:word;InstrumentNum:word):longint; far; external;
function _CP_GetSampleC4Spd(SampleNum:word;InstrumentNum:word):word; far; external;
function _CP_GetSampleVolume(SampleNum:word;InstrumentNum:word):byte; far; external;
function _CP_GetSamplePanning(SampleNum:word;InstrumentNum:word):byte; far; external;
function _CP_GetSampleLoopType(SampleNum:word;InstrumentNum:word):byte; far; external;
function _CP_GetSampleLoopBegin(SampleNum:word;InstrumentNum:word):longint; far; external;
function _CP_GetSampleLength(SampleNum:word;InstrumentNum:word):longint; far; external;
function _CP_GetSample16Bit(SampleNum:word;InstrumentNum:word):byte; far; external;
function _CP_GetSampleMute(SampleNum:word;InstrumentNum:word):byte; far; external;
{$L CP2ASM.OBJ}


function CP_GetIRQ:byte;
begin
  CP_GetIRQ:=_CP_GetIRQ;
end;

procedure CP_SetIRQ(NewIRQ:byte);
begin
  _CP_SetIRQ(NewIRQ);
end;

function CP_GetDMA:byte;
begin
  CP_GetDMA:=_CP_GetDMA;
end;

procedure CP_SetDMA(NewDMA:byte);
begin
  _CP_SetDMA(NewDMA);
end;

function CP_GetBasePort:word;
begin
  CP_GetBasePort:=_CP_GetBasePort;
end;

procedure CP_SetBasePort(NewBasePort:word);
begin
  _CP_SetBasePort(NewBasePort);
end;

procedure CP_SetLineIn(LineInState:byte);
begin
  _CP_SetLineIn(LineInState);
end;

procedure CP_SetMicIn(MicInState:byte);
begin
  _CP_SetMicIn(MicInState);
end;

function CP_LoadModule(ModName:string;StartOffset:longint;TransferMode:byte):byte;
var c:char;
begin
  c:=ModName[length(ModName)+1];
  ModName[length(ModName)+1]:=#0;
  CP_LoadModule:=_CP_LoadModule(TransferMode,StartOffset,seg(ModName),ofs(ModName)+1);
  ModName[length(ModName)+1]:=c;
end;

function CP_LoadOnlyPatterns(ModName:string;StartOffset:longint;TransferMode:byte):byte;
var c:char;
begin
  c:=ModName[length(ModName)+1];
  ModName[length(ModName)+1]:=#0;
  CP_LoadOnlyPatterns:=_CP_LoadOnlyPatterns(TransferMode,StartOffset,seg(ModName),ofs(ModName)+1);
  ModName[length(ModName)+1]:=c;
end;

procedure CP_FreeModule;
begin
  _CP_FreeModule;
end;

procedure CP_StartModule(Amplification:byte;DefaultPanning:byte;TimerMode:byte);
begin
  _CP_StartModule(TimerMode,DefaultPanning,Amplification);
end;

procedure CP_StopModule;
begin
  _CP_StopModule;
end;

function CP_PauseModule:byte;
begin
  CP_PauseModule:=_CP_PauseModule;
end;

procedure CP_SetSpeedZeroMode(SpeedZeroMode:byte);
begin
  _CP_SetSpeedZeroMode(SpeedZeroMode);
end;

procedure CP_SetPanEffectMode(PanEffectMode:byte);
begin
  _CP_SetPanEffectMode(PanEffectMode);
end;

procedure CP_SetVBlankMode(VBlankMode:byte);
begin
  _CP_SetVBlankMode(VBlankMode);
end;

procedure CP_SetAmigaLimitsMode(AmigaLimitsMode:byte);
begin
  _CP_SetAmigaLimitsMode(AmigaLimitsMode);
end;

function CP_GetModuleName:string;
var b:byte;
    cachedword:longint;
    nameseg,nameofs:word;
begin
  b:=0;
  cachedword:=_CP_GetModuleName;
  nameofs:=word(cachedword);
  nameseg:=word(cachedword shr 16);
  while (mem[nameseg:nameofs+b]<>0) do
  begin
    CP_GetModuleName[b+1]:=chr(mem[nameseg:nameofs+b]);
    inc(b);
  end;
  CP_GetModuleName[0]:=chr(b);
end;

function CP_GetModuleType:byte;
begin
  CP_GetModuleType:=_CP_GetModuleType;
end;

function CP_GetModuleLength:byte;
begin
  CP_GetModuleLength:=_CP_GetModuleLength;
end;

function CP_GetNumOfPatterns:word;
begin
  CP_GetNumOfPatterns:=_CP_GetNumOfPatterns;
end;

function CP_GetNumOfInstruments:byte;
begin
  CP_GetNumOfInstruments:=_CP_GetNumOfInstruments;
end;

function CP_GetNumOfChannels:byte;
begin
  CP_GetNumOfChannels:=_CP_GetNumOfChannels;
end;

function CP_GetNumOfUsedChannels:byte;
begin
  CP_GetNumOfUsedChannels:=_CP_GetNumOfUsedChannels;
end;

function CP_GetRestartPosition:byte;
begin
  CP_GetRestartPosition:=_CP_GetRestartPosition;
end;

function CP_GetUsedPatternMemory:longint;
begin
  CP_GetUsedPatternMemory:=_CP_GetUsedPatternMemory;
end;

function CP_GetUsedInstrumentInfoMemory:longint;
begin
  CP_GetUsedInstrumentInfoMemory:=_CP_GetUsedInstrumentInfoMemory;
end;

function CP_GetUsedGUSMemory:longint;
begin
  CP_GetUsedGUSMemory:=_CP_GetUsedGUSMemory;
end;

function CP_GetFileSize:longint;
begin
  CP_GetFileSize:=_CP_GetFileSize;
end;

procedure CP_SetPosition(NewPosition:word);
begin
  _CP_SetPosition(NewPosition);
end;

procedure CP_SetGlobalVolume(NewVolume:word);
begin
  _CP_SetGlobalVolume(NewVolume);
end;

procedure CP_SetMainVolume(NewVolume:word);
begin
  _CP_SetMainVolume(NewVolume);
end;

procedure CP_SetSpeed(NewSpeed:word);
begin
  _CP_SetSpeed(NewSpeed);
end;

procedure CP_SetTempo(NewTempo:word);
begin
  _CP_SetTempo(NewTempo);
end;

procedure CP_RestoreSpeedAndTempo;
begin
  _CP_RestoreSpeedAndTempo;
end;

procedure CP_SetDefaultPanning(DefaultPanning:shortint);
begin
  _CP_SetDefaultPanning(DefaultPanning);
end;

function CP_GetRow:byte;
begin
  CP_GetRow:=_CP_GetRow;
end;

function CP_GetNumOfRows(PositionNum:word):word;
begin
  CP_GetNumOfRows:=_CP_GetNumOfRows(PositionNum);
end;

function CP_GetPosition:byte;
begin
  CP_GetPosition:=_CP_GetPosition;
end;

function CP_GetPattern:byte;
begin
  CP_GetPattern:=_CP_GetPattern;
end;

function CP_GetGlobalVolume:byte;
begin
  CP_GetGlobalVolume:=_CP_GetGlobalVolume;
end;

procedure CP_RestoreInitialVolume;
begin
  _CP_RestoreInitialVolume;
end;

function CP_GetMainVolume:byte;
begin
  CP_GetMainVolume:=_CP_GetMainVolume;
end;

function CP_GetSpeed:byte;
begin
  CP_GetSpeed:=_CP_GetSpeed;
end;

function CP_GetTempo:byte;
begin
  CP_GetTempo:=_CP_GetTempo;
end;

function CP_GetPlayingTime:word;
begin
  CP_GetPlayingTime:=_CP_GetPlayingTime;
end;

function CP_GetTimer:longint;
begin
  CP_GetTimer:=_CP_GetTimer;
end;

function CP_GetLoopCounter:byte;
begin
  CP_GetLoopCounter:=_CP_GetLoopCounter;
end;

function CP_SetChannelMute(ChannelNum:word;MuteState:byte):byte;
begin
  _CP_SetChannelMute(MuteState,ChannelNum);
end;

procedure CP_SetChannelPanning(ChannelNum:word;NewPanning:byte);
begin
  _CP_SetChannelPanning(NewPanning,ChannelNum);
end;

procedure CP_PlaySample(ChannelNum:word;InstrumentNum:word;SampleNum:word;Note:byte;Octave:byte);
begin
  _CP_PlaySample(Octave,Note,SampleNum,InstrumentNum,ChannelNum);
end;

procedure CP_StopSample(ChannelNum:word);
begin
  _CP_StopSample(ChannelNum);
end;

function CP_GetChannelNote(ChannelNum:word):byte;
begin
  CP_GetChannelNote:=_CP_GetChannelNote(ChannelNum);
end;

function CP_GetChannelOctave(ChannelNum:word):byte;
begin
  CP_GetChannelOctave:=_CP_GetChannelOctave(ChannelNum);
end;

function CP_GetChannelVolume(ChannelNum:word):byte;
begin
  CP_GetChannelVolume:=_CP_GetChannelVolume(ChannelNum);
end;

function CP_GetChannelEffect(ChannelNum:word):byte;
begin
  CP_GetChannelEffect:=_CP_GetChannelEffect(ChannelNum);
end;

function CP_GetChannelEffectParams(ChannelNum:word):byte;
begin
  CP_GetChannelEffectParams:=_CP_GetChannelEffectParams(ChannelNum);
end;

function CP_GetChannelInstrument(ChannelNum:word):byte;
begin
  CP_GetChannelInstrument:=_CP_GetChannelInstrument(ChannelNum);
end;

function CP_GetChannelSample(ChannelNum:word):byte;
begin
  CP_GetChannelSample:=_CP_GetChannelSample(ChannelNum);
end;

function CP_GetChannelBar(ChannelNum:word):byte;
begin
  CP_GetChannelBar:=_CP_GetChannelBar(ChannelNum);
end;

function CP_GetChannelNoteTrigger(ChannelNum:word):byte;
begin
  CP_GetChannelNoteTrigger:=_CP_GetChannelNoteTrigger(ChannelNum);
end;

function CP_GetChannelPanning(ChannelNum:word):byte;
begin
  CP_GetChannelPanning:=_CP_GetChannelPanning(ChannelNum);
end;

function CP_GetChannelMute(ChannelNum:word):byte;
begin
  CP_GetChannelMute:=_CP_GetChannelMute(ChannelNum);
end;

function CP_SetSampleMute(InstrumentNum:word;SampleNum:word;MuteState:byte):byte;
begin
  _CP_SetSampleMute(MuteState,SampleNum,InstrumentNum);
end;

function CP_GetInstrumentName(InstrumentNum:word):string;
var b:byte;
    cachedword:longint;
    nameseg,nameofs:word;
begin
  b:=0;
  cachedword:=_CP_GetInstrumentName(InstrumentNum);
  nameofs:=word(cachedword);
  nameseg:=word(cachedword shr 16);
  while (mem[nameseg:nameofs+b]<>0) do
  begin
    CP_GetInstrumentName[b+1]:=chr(mem[nameseg:nameofs+b]);
    inc(b);
  end;
  CP_GetInstrumentName[0]:=chr(b);
end;

function CP_GetNumOfSamples(InstrumentNum:word):byte;
begin
  CP_GetNumOfSamples:=_CP_GetNumOfSamples(InstrumentNum);
end;

function CP_GetSampleName(InstrumentNum:word;SampleNum:word):string;
var b:byte;
    cachedword:longint;
    nameseg,nameofs:word;
begin
  b:=0;
  cachedword:=_CP_GetSampleName(SampleNum,InstrumentNum);
  nameofs:=word(cachedword);
  nameseg:=word(cachedword shr 16);
  while (mem[nameseg:nameofs+b]<>0) do
  begin
    CP_GetSampleName[b+1]:=chr(mem[nameseg:nameofs+b]);
    inc(b);
  end;
  CP_GetSampleName[0]:=chr(b);
end;

function CP_GetSampleSize(InstrumentNum:word;SampleNum:word):longint;
begin
  CP_GetSampleSize:=_CP_GetSampleSize(SampleNum,InstrumentNum);
end;

function CP_GetSampleC4Spd(InstrumentNum:word;SampleNum:word):word;
begin
  CP_GetSampleC4Spd:=_CP_GetSampleC4Spd(SampleNum,InstrumentNum);
end;

function CP_GetSampleVolume(InstrumentNum:word;SampleNum:word):byte;
begin
  CP_GetSampleVolume:=_CP_GetSampleVolume(SampleNum,InstrumentNum);
end;

function CP_GetSamplePanning(InstrumentNum:word;SampleNum:word):byte;
begin
  CP_GetSamplePanning:=_CP_GetSamplePanning(SampleNum,InstrumentNum);
end;

function CP_GetSampleLoopType(InstrumentNum:word;SampleNum:word):byte;
begin
  CP_GetSampleLoopType:=_CP_GetSampleLoopType(SampleNum,InstrumentNum);
end;

function CP_GetSampleLoopBegin(InstrumentNum:word;SampleNum:word):longint;
begin
  CP_GetSampleLoopBegin:=_CP_GetSampleLoopBegin(SampleNum,InstrumentNum);
end;

function CP_GetSampleLength(InstrumentNum:word;SampleNum:word):longint;
begin
  CP_GetSampleLength:=_CP_GetSampleLength(SampleNum,InstrumentNum);
end;

function CP_GetSample16Bit(InstrumentNum:word;SampleNum:word):byte;
begin
  CP_GetSample16Bit:=_CP_GetSample16Bit(SampleNum,InstrumentNum);
end;

function CP_GetSampleMute(InstrumentNum:word;SampleNum:word):byte;
begin
  CP_GetSampleMute:=_CP_GetSampleMute(SampleNum,InstrumentNum);
end;

end.
