#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define O_QUITE     0x0001

int Options = 0;

char *Filename;
char *TimeStamp;

char Usage[] =
    "CHKSTAMP.EXE Version 1.0\n"
    "\n"
    "usage:\n"
    "    CHKSTAMP [options] turn_filename time-stamp\n"
    "\n"
    "    options:\n"
    "\n"
    "        q   : Quiet mode - do not print information\n"
    "        ?   : Help\n"
    "        h   : Help\n"
    "\n"
    "\n"
    "    turn_filename:\n"
    "\n"
    "        The player's turn file.\n"
    "        example: player1.trn\n"
    "\n"
    "\n"
    "    time-stamp:\n"
    "\n"
    "        The time-stamp from host.log\n"
    "        example: 02-28-199418:01:29\n"
    "\n"
    "\n"
    "returns:\n"
    "\n"
    "    -1  : An error has occurred\n"
    "     0  : File is stall\n"
    "     1  : File is current\n"
    "\n";

void DoArgs (int argc, char **argv)
{
    char *cptr;
    argv++;

    while (**argv == '-' || **argv == '/')
    {
        cptr = *argv+1;

        while (*cptr)
        {
            switch (*cptr)
            {
              case 'Q':
              case 'q':
                Options |= O_QUITE;
                break;

              case '?':
              case 'H':
              case 'h':
              default:
                puts (Usage);
                exit (-1);
            }

            cptr++;
        }


        argv++;
        argc--;
    }

    if (argc != 3)
    {
        puts (Usage);
        exit (-1);
    }

    Filename  = *argv++;
    TimeStamp = *argv;
}

int main (int argc, char **argv)
{
    FILE *fp;
    char carray [19] = "";
    int i;

    DoArgs (argc, argv);

    fp = fopen (Filename, "rb");

    if (fp)
    {
        fseek (fp, 6, SEEK_SET);
        i = fread (carray, 18, 1, fp);
        fclose (fp);

        if (i == 1)
        {
            if (!strcmp (carray, TimeStamp))
            {
                if (!(Options & O_QUITE))
                {
                    puts ("Time-Stamp is Current\n");
                }

                return 1;
            }
            else
            {
                if (!(Options & O_QUITE))
                {
                    puts ("Time-Stamp is not Current\n");
                }

                return 0;
            }
        }
    }

    if (!(Options & O_QUITE))
    {
        puts ("An Error has occured\n");
    }
    return -1;
}
