//	CALVIN.C
//	Patrick Tennberg, 1994,95,96

#define	STRICT
#include	"includes.h"
#pragma	hdrstop
#include	"tools.h"
#include	"lawfile.h"
#include	"setup.h"
#include	"about.h"
#include	"timer.h"
#include	"regdata.h"
#include	"resource.h"

//	This data is shared between all
//	instances of the application
#pragma data_seg(".sdata")
LONG lUsageCount = -1;
#pragma data_seg()

#define	MAX_RESSTRINGLEN	50

//	Constants
const LPCSTR szAppName			= "CALVIN";
const LPCSTR szLocalData		= "LOCALDATA";
const LPCSTR szFontFaceName =	"Times New Roman";

//	Global atom to a local data structure used
//	by DlgCalvin
static ATOM	gaLocalData;

//	Variables used by DlgCalvin
typedef struct
  {
	int  				cyIcon;
	RECT				rcBmp;
	RECT				rcBmpPos;
	HBRUSH			hBrush;
	HFONT				hNormalFont;
	HDC					hdcWindowBmp;
	BOOL				fAlwaysOnTop;
	BOOL				fTimerRunning;
  HICON       hIcon;
  HBITMAP     hOldBitmap;
	TFileData		fd;
  }
TSLocalData,*PTSLocalData;

//	If the timer is on, then turn it of and kill it
void CheckTimer(HWND hWnd)
  {
	PTSLocalData	lpld = (PTSLocalData) GetProp(hWnd,(LPCSTR)gaLocalData);

	if (TRUE == lpld->fTimerRunning)
	  {
		Timer_Uninstall(hWnd);
		lpld->fTimerRunning = FALSE;
	  }
  }

//	Adjust the rectangle so it embrace only the
//	area where we writes the laws.
void AdjustRectangle(LPRECT lprc,int cyIcon)
  {
	lprc->top 		+= 10 + cyIcon;
	lprc->right 	-= 5;
	lprc->left 		+= 5;
	lprc->bottom 	-= 5;
  }

//	Create's a compatible device context and selects
//	a bitmap into it. We use this dc for painting the
//	the calvin icon, header and the law.
void CreateScreenBitmap(HWND hWnd,BOOL fCreateRes)
  {
	HDC						hdc;
  HBRUSH        hOldBrush;
	HPEN					hPen,hOldPen;
	HFONT					hBoldFont,hOldFont;
	int 					cxIcon;
	int						nBoldFontHeight,y;
	LOGFONT				lfTemplate;
	char					szResString[MAX_RESSTRINGLEN];
	LPRECT				lprc;
	PTSLocalData	lpld = (PTSLocalData) GetProp(hWnd,(LPCSTR)gaLocalData);

	//	Setup a brush to be used when painting the
	//	area occupied by the static control.
	if (NULL != lpld->hBrush)
		DeleteBrush(lpld->hBrush);
	lpld->hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
	//	Get size of standard window icon
	cxIcon = GetSystemMetrics(SM_CXICON);
	lpld->cyIcon = GetSystemMetrics(SM_CYICON);
	//	Load the header string
	ResString(hWnd,IDS_CALVINSAYS,szResString,MAX_RESSTRINGLEN);
	//	Get a black pen used for drawing a frame
	hPen = GetStockObject(BLACK_PEN);
	//	Reset the font template
	memset(&lfTemplate,0,sizeof(LOGFONT));
	//	Normal font
	hdc = GetDC(hWnd);
	if (TRUE == fCreateRes)
	  {
		lstrcpy(lfTemplate.lfFaceName,szFontFaceName);
		lfTemplate.lfHeight = POINT2PIXEL(hdc,8);
		lpld->hNormalFont = CreateFontIndirect(&lfTemplate);
	  }
	//	Header font
	lfTemplate.lfHeight = POINT2PIXEL(hdc,10);
	lfTemplate.lfWeight = FW_BOLD;
	hBoldFont = CreateFontIndirect(&lfTemplate);
	nBoldFontHeight = (lfTemplate.lfHeight * -1);
	ReleaseDC(hWnd,hdc);
	//	Get size of static control and convert it
	//	to client coordinates
	GetWindowRect(GetDlgItem(hWnd,IDC_BITMAPFRAME),&lpld->rcBmp);
  MapWindowPoints(HWND_DESKTOP,hWnd,(LPPOINT)&lpld->rcBmp,2);
	//	Save one unmodifed rc to be use when bit blitting the bitmap
	lpld->rcBmpPos = lpld->rcBmp;
	//	Adjust rectangle to the bitmap size
	lpld->rcBmp.right		= (lpld->rcBmp.right - lpld->rcBmp.left);
	lpld->rcBmp.bottom 	= (lpld->rcBmp.bottom - lpld->rcBmp.top);
	lpld->rcBmp.top 		= lpld->rcBmp.left = 0;
	lprc = &lpld->rcBmp;
	//	Create a compatible device context
	if (TRUE == fCreateRes)
	  {
		HDC hdcScreen;
    HBITMAP hBitmap;
		// We could of course use GetDC(NULL) to achive the
		// same result.
		hdcScreen = CreateDC("DISPLAY",NULL,NULL,NULL);
		lpld->hdcWindowBmp = CreateCompatibleDC(hdcScreen);
		hBitmap = CreateCompatibleBitmap(
			hdcScreen,
			lprc->right,
			lprc->bottom
		);
		lpld->hOldBitmap = SelectBitmap(lpld->hdcWindowBmp,hBitmap);
		DeleteDC(hdcScreen);
	  }
	//	Paint the frame
	hOldBrush = SelectBrush(lpld->hdcWindowBmp,lpld->hBrush);
	hOldPen = SelectPen(lpld->hdcWindowBmp,hPen);
	Rectangle(lpld->hdcWindowBmp,lprc->left,lprc->top,lprc->right,lprc->bottom);
	//	Draw icon
	DrawIcon(lpld->hdcWindowBmp,lprc->left + 5,lprc->top + 5,lpld->hIcon);
	//	Set text color
	SetBkColor(lpld->hdcWindowBmp,GetSysColor(COLOR_WINDOW));
	SetTextColor(lpld->hdcWindowBmp,GetSysColor(COLOR_WINDOWTEXT));
	//	Draw header text
	hOldFont = SelectFont(lpld->hdcWindowBmp,hBoldFont);
	y = ((lpld->cyIcon - nBoldFontHeight) / 2) + lprc->top + 5;
	TextOut(lpld->hdcWindowBmp,lprc->left + cxIcon + 10,y,szResString,lstrlen(szResString));
	//	Adjust rectangle for display law text
	AdjustRectangle(lprc,lpld->cyIcon);
	//	Delete used resources
  SelectBrush(lpld->hdcWindowBmp,hOldBrush);
  SelectPen(lpld->hdcWindowBmp,hOldPen);
  SelectFont(lpld->hdcWindowBmp,hOldFont);
	DeleteFont(hBoldFont);
  }

//	Writes the law text on our dc
BOOL DrawLawTextOnBitmap(HWND hWnd)
  {
	int						nLen;
	BOOL					fReturn;
  HBRUSH        hOldBrush;
  HFONT         hOldFont;
	char					szLawStr[MAX_LAWLEN];
	PTSLocalData	lpld = (PTSLocalData) GetProp(hWnd,(LPCSTR)gaLocalData);
	LPRECT				lprc = &lpld->rcBmp;

	//	Get a random law to display
	fReturn = GetRandomLaw(&(lpld->fd),szLawStr);
	nLen = lstrlen(szLawStr);
	//	Clear text area
	hOldBrush = SelectBrush(lpld->hdcWindowBmp,lpld->hBrush);
	PatBlt(lpld->hdcWindowBmp,
		lprc->left,
		lprc->top,
		lprc->right - lprc->left,
		lprc->bottom - lprc->top,
		PATCOPY
	);
	//	draw text
	hOldFont = SelectFont(lpld->hdcWindowBmp,lpld->hNormalFont);
	DrawText(lpld->hdcWindowBmp,szLawStr,nLen,lprc,DT_LEFT | DT_WORDBREAK);

  SelectBrush(lpld->hdcWindowBmp,hOldBrush);
  SelectFont(lpld->hdcWindowBmp,hOldFont);

	return fReturn;
  }

//	WM_INITDIALOG
#ifdef __BORLANDC__
  #pragma argsused
#endif
BOOL Calvin_OnInitDialog(HWND hWnd,HWND hWndFocus,LPARAM lParam)
  {
	HMENU					hMenu;
	PTSLocalData	lpld;
	HWND					hwndCheckBoxCtl;
	char					szResString[MAX_RESSTRINGLEN];

	//	Get hWnd for the checkbox
	hwndCheckBoxCtl = GetDlgItem(hWnd,IDC_ALWAYSONTOP);
	//	Allocate a local data structure used by dialog
	lpld = HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,sizeof(TSLocalData));
	//	Associate an atom to the local data structure
	gaLocalData = GlobalAddAtom(szLocalData);
	SetProp(hWnd,(LPCSTR)gaLocalData,lpld);
	//	If we can't allocate any memory, lets return to Windows.
	if (NULL == lpld)
	  {
		EndDialog(hWnd,0);
		return TRUE;
	  }
	//	Associate an icon with the dialog box
	lpld->hIcon = LoadIcon((HINSTANCE)GetWindowLong(hWnd,GWL_HINSTANCE),szAppName);
	//  Set icon for the system menu
	SendMessage(hWnd,WM_SETICON,FALSE,(LPARAM)lpld->hIcon);
  //  Associate an icon with Calvin so you will see an bitmap
  //  when using ALT+TAB. Debug version of Windows will scream
  //  about changing a system class. But each and every window
  //  gets there own copy of the class data, so this should not
  //  be any problem
  SetClassLong(hWnd,GCL_HICON,(long)lpld->hIcon);
	//	Add item to system menu
	hMenu = GetSystemMenu(hWnd,FALSE);
	AppendMenu(hMenu,MF_SEPARATOR,0,NULL);
	AppendMenu(hMenu,MF_STRING,IDM_SETUP,ResString(hWnd,IDS_SETUP,szResString,MAX_RESSTRINGLEN));
	AppendMenu(hMenu,MF_STRING,IDM_ABOUT,ResString(hWnd,IDS_ABOUT,szResString,MAX_RESSTRINGLEN));
	//	Open law file and get a random law.
	LoadLawFile(&(lpld->fd));
  //  Create the bitmap we use for of line painting
	CreateScreenBitmap(hWnd,TRUE);
  //  If we encountered an error then close down the timer
  //  we use to let the user catch the problem
  if (TRUE == lpld->fd.failed)
    CheckTimer(hWnd);
  //  Get a law or a error message depending on lpld->fd.failed
  //  if there is any error then gray the "next law" button
	if (FALSE == DrawLawTextOnBitmap(hWnd))
		Button_Enable(GetDlgItem(hWnd,IDC_NEXT),FALSE);
	//	Retrive AlwaysOnTop flag from registry
	lpld->fAlwaysOnTop = RetriveData(RT_ALWAYSONTOP,1);
	CenterWindow(hWnd,lpld->fAlwaysOnTop);
	//	Init check box
	Button_SetCheck(hwndCheckBoxCtl,lpld->fAlwaysOnTop);
	//	Create an timer. Because the display time is stored as an multipel
	//  of 5 seconds, we need to multiply the stored value by 5. The display
	//  time is fetched from the registry.
	lpld->fTimerRunning = Timer_Install(hWnd,RetriveData(RT_DISPLAYTIME,DEFAULT_DISPLAYTIME) * 5);

	return TRUE;
  }

//	WM_DESTROY
void Calvin_OnDestroy(HWND hWnd)
  {
	PTSLocalData	lpld = (PTSLocalData) GetProp(hWnd,(LPCSTR)gaLocalData);

	if (NULL != lpld)
	  {
    HBITMAP hBitmap;

		DeleteBrush(lpld->hBrush);
		DeleteFont(lpld->hNormalFont);
    hBitmap = SelectBitmap(lpld->hdcWindowBmp,lpld->hOldBitmap);
    DeleteBitmap(hBitmap);
		DeleteDC(lpld->hdcWindowBmp);
		UnloadLawFile(&(lpld->fd));
		HeapFree(GetProcessHeap(),0,lpld->fd.lpdwIndex);
		RemoveProp(hWnd,(LPCSTR)gaLocalData);
		GlobalDeleteAtom(gaLocalData);
		HeapFree(GetProcessHeap(),0,lpld);
	  }
  }

//	WM_PAINT
BOOL Calvin_OnPaint(HWND hWnd)
  {
	HDC						hdc;
	RECT					rc;
	PAINTSTRUCT		ps;
	PTSLocalData	lpld = (PTSLocalData) GetProp(hWnd,(LPCSTR)gaLocalData);

	//	We optimize the output so we only BitBlt the part of the bitmap that
	//	really needs to be repainted.
	hdc = BeginPaint(hWnd,&ps);
  // When xSrc and ySrc are negative then xDest and yDest are
  // combined xDest = xDest + abs(xDest) and the width is 
  // shrinked with xDest pixels. The first time we recive a
  // WM_PAINT message xDest and yDest will be zero, but xSrc and
  // ySrc will both be -15 and this means that xDest = yDest = 15.
  // BitBlt will not blit more than the actual size of our bitmap
  // so it does not matter that rc.rigth - rc.left is more than the
  // actual size of the bitmap.Using this technique simples the code
  // and reduces the number of calculation. If any one sees any
  // drawback with this method, then please contact me.
	rc = ps.rcPaint;
	BitBlt(hdc,
	  rc.left,
		rc.top,
		rc.right - rc.left,
		rc.bottom - rc.top,
		lpld->hdcWindowBmp,
		rc.left - lpld->rcBmpPos.left,
		rc.top - lpld->rcBmpPos.top,
		SRCCOPY
	);
	EndPaint(hWnd,&ps);

	return FALSE;
  }

//	WM_COMMAND
#ifdef __BORLANDC__
  #pragma argsused
#endif
void Calvin_OnCommand(HWND hWnd,int nId,HWND hWndCtl,UINT uCodeNotify)
  {
	PTSLocalData	lpld = (PTSLocalData) GetProp(hWnd,(LPCSTR)gaLocalData);

	//	The user is not silently using the program, kill the timer
	//	and let the user exit the program manually.
	CheckTimer(hWnd);
	switch (nId)
	  {
		case IDC_OK:
		case IDC_CANCEL:
			StoreData(RT_ALWAYSONTOP,lpld->fAlwaysOnTop);
			EndDialog(hWnd,nId);
			break;
		case IDC_NEXT:
		  {	//	The user presses the next button
			RECT rc;

			if (FALSE == DrawLawTextOnBitmap(hWnd))
				Button_Enable(GetDlgItem(hWnd,IDC_NEXT),FALSE);
			//	Adjust rectangle for display law text
			rc = lpld->rcBmpPos;
			//	We only want to invalidate the "law" part of the
			//	display area.
			AdjustRectangle(&rc,lpld->cyIcon);
			InvalidateRect(hWnd,&rc,FALSE);
			break;
		  }
		case IDC_ALWAYSONTOP:
			lpld->fAlwaysOnTop = Button_GetCheck(GetDlgItem(hWnd,IDC_ALWAYSONTOP));

			if (TRUE == lpld->fAlwaysOnTop)
				SetWindowPos(hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE);
			else
				SetWindowPos(hWnd,HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE);
			break;

	  }
  }

//	WM_SYSCOMMAND
#ifdef __BORLANDC__
  #pragma argsused
#endif
BOOL Calvin_OnSysCommand(HWND hWnd, UINT cmd, int x, int y)
  {
	switch (cmd)
	  {
		case IDM_SETUP:
			CheckTimer(hWnd);
			LaunchSetupDlg(hWnd);
			return TRUE;
		case IDM_ABOUT:
			CheckTimer(hWnd);
			LaunchAboutDlg(hWnd);
			return TRUE;
	  }
	return FALSE;
  }

//	WM_SYSCOLORCHANGE
void Calvin_OnSysColorChange(HWND hWnd)
  {
	CreateScreenBitmap(hWnd,FALSE);
	DrawLawTextOnBitmap(hWnd);
  }

BOOL CALLBACK DlgCalvin(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
  {
	BOOL fProcessed = TRUE;

	switch (uMsg)
	  {
		HANDLE_MSG(hWnd,WM_INITDIALOG,Calvin_OnInitDialog);
		HANDLE_MSG(hWnd,WM_DESTROY,Calvin_OnDestroy);
		HANDLE_MSG(hWnd,WM_PAINT,Calvin_OnPaint);
		HANDLE_MSG(hWnd,WM_COMMAND,Calvin_OnCommand);
		HANDLE_MSG(hWnd,WM_SYSCOMMAND,Calvin_OnSysCommand);
		HANDLE_MSG(hWnd,WM_SYSCOLORCHANGE,Calvin_OnSysColorChange);
		default:
			fProcessed = FALSE;
	  }
	return fProcessed;
  }

#ifdef __BORLANDC__
  #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
  {
	//	Increase usage count
	BOOL fFirstInstance = (InterlockedIncrement(&lUsageCount) == 0);

	//	If Calvin is running, let find him and make
	//	him the active window
	if (!fFirstInstance)
	  {
		HWND hWnd = FindWindow(NULL,szAppName);

		BringWindowToTop(hWnd);
		if (TRUE == IsIconic(hWnd))
			ShowWindow(hWnd,SW_RESTORE);
		SetForegroundWindow(hWnd);
	  }
	else
	  {
		//	Init common controls
		InitCommonControls();
		//	Launch main dialog box
		DialogBox(hInstance,szAppName,NULL,DlgCalvin);
	  }
	//	Decrease usage count
	InterlockedDecrement(&lUsageCount);

	return 0;
  }