//	SETUP.C
//	Patrick Tennberg, 1994,95,96

#define	STRICT
#include	"includes.h"
#pragma	hdrstop
#include	"tools.h"
#include	"setup.h"
#include 	"regdata.h"
#include	"resource.h"

//	Constants
static LPCSTR szDialogName = "SETUP";

//	WM_INITDIALOG
#ifdef __BORLANDC__
  #pragma argsused
#endif
BOOL Setup_OnInitDialog(HWND hWnd,HWND hWndFocus,LPARAM lParam)
  {
 	char	szValue[4];
	int		nDispTime;
	HWND	hwndEditCtl;
	HWND	hwndUpDownCtl;

	//	Center dialog
	CenterWindow(hWnd,FALSE);
	//	Retrive data from the registry
	nDispTime = RetriveData(RT_DISPLAYTIME,DEFAULT_DISPLAYTIME);
	//	Get windows handles to the controls
	hwndUpDownCtl = GetDlgItem(hWnd,IDC_UPDOWN);
	hwndEditCtl = GetDlgItem(hWnd,IDC_SHOWTIME);
	//	Init UpDown control
	//
	//	Set range: Upper = 60, lower = 1
	SendMessage(hwndUpDownCtl,UDM_SETRANGE,0,MAKELONG(60,1));
	//	Set current position
	SendMessage(hwndUpDownCtl,UDM_SETPOS,0,nDispTime);
	//	Init edit control
	//
	//	Set initial value. We store the value as an multiple of 5 seconds.
	itoa(nDispTime * 5,szValue,10);
	Edit_SetText(hwndEditCtl,szValue);

	return TRUE;
  }

//	WM_COMMAND
#ifdef __BORLANDC__
  #pragma argsused
#endif
void Setup_OnCommand(HWND hWnd,int nId,HWND hWndCtl,UINT uCodeNotify)
  {
	int		nDispTime;
	HWND	hwndUpDown = GetDlgItem(hWnd,IDC_UPDOWN);

	switch (nId)
	  {
		case IDC_OK:
			nDispTime = LOWORD(SendMessage(hwndUpDown,UDM_GETPOS,0,0));
			StoreData(RT_DISPLAYTIME,nDispTime);
		case IDC_CANCEL:
			EndDialog(hWnd,nId);
			break;
	  }
  }

//	WM_VSCROLL
#ifdef __BORLANDC__
  #pragma argsused
#endif
void Setup_OnVScroll(HWND hWnd,HWND hwndCtl,UINT code,int pos)
  {
	//	An UpDown-control sends an WM_VSCROLL message when the
	//	position changes.
	char	szNewValue[4];
	HWND	hwndEditCtl = GetDlgItem(hWnd,IDC_SHOWTIME);

	itoa(pos * 5,szNewValue,10);
	Edit_SetText(hwndEditCtl,szNewValue);
  }

#ifdef __BORLANDC__
  #pragma argsused
#endif
BOOL CALLBACK DlgSetup(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
  {
	BOOL	fProcessed = TRUE;

	switch (uMsg)
	  {
		HANDLE_MSG(hWnd,WM_INITDIALOG,Setup_OnInitDialog);
		HANDLE_MSG(hWnd,WM_COMMAND,Setup_OnCommand);
		HANDLE_MSG(hWnd,WM_VSCROLL,Setup_OnVScroll);
		default:
			fProcessed = FALSE;
	  }

	return fProcessed;
  }

void LaunchSetupDlg(HWND hWndParent)
  {
	HINSTANCE hInstance = (HINSTANCE) GetWindowLong(hWndParent,GWL_HINSTANCE);		

	DialogBox(hInstance,szDialogName,hWndParent,DlgSetup);
  }
