#ifndef	__LAWFILE_H
#define	__LAWFILE_H

#define	MAX_LAWLEN	 500
#define ERR_NONE       0
#define ERR_GENERIC   -1
#define ERR_LAWTOLONG -2

typedef struct {
	HANDLE		hFile;			//	File handle to lawfile			
	HANDLE		hFileMap;		//	Handle the the lawfile as a memory mapped file
	LPSTR			lpsFile;		//	A pointer to the lawfile.
	DWORD			dwFileSize;	
	FILETIME	ftLastWrite;
	BOOL			failed;			//	If we can't find the law/index file, failed = TRUE
	LPDWORD		lpdwIndex;	//	A pointer to the index file.
	UINT 			nNoLaws;		//	Number of laws in the law file
  int       nErrorCode;
  int       nStringLength;
} TFileData, *PTFileData;

//	Function prototypes
void LoadLawFile(PTFileData fd);		
void UnloadLawFile(PTFileData fd);
BOOL GetRandomLaw(PTFileData fd,LPSTR szLaw);

#endif
