NAME
     curses - screen functions with optimal cursor motion

SYNTAX
     cc [ flags ] files -lcurses -ltermcap [ libraries ]

DESCRIPTION
     These routines give the user a method of updating screens with
     reasonable optimization.  They keep an image of the current
     screen, and the user sets up an image of a new one.  Then the
     refresh subroutine tells the routines to make the current screen
     look like the new one.  To initialize the routines, the routine
     initscr must be called before any of the other routines that deal
     with windows and screens are used.  The routine endwin should be
     called before exiting.

FUNCTIONS
     addch(ch)                     add a character to stdscr
     addstr(str)                   add a string to stdscr
     box(win,vert,hor)             draw a box around a window
     clear()                       clear stdscr
     clearok(scr,boolf)            set clear flag for scr
     clrtobot()                    clear to bottom on stdscr
     clrtoeol()                    clear to end of line on stdscr
     crmode()                      set cbreak mode
     delch()                       delete a character
     deleteln()                    delete a line
     delwin(win)                   delete win
     echo()                        set echo mode
     endwin()                      end window modes
     erase()                       erase stdscr
     getch()                       get a char through stdscr
     getcap(name)                  get terminal capability name
     getstr(str)                   get a string through stdscr
     gettmode()                    get tty modes
     getyx(win,y,x)                get (y,x) co-ordinates
     inch()                        get char at current (y,x) co-ordinates
     initscr()                     initialize screens
     insch(c)                      insert a char
     insertln()                    insert a line
     leaveok(win,boolf)            set leave flag for win
     longname(termbuf,name)        get long name from termbuf
     move(y,x)                     move to (y,x) on stdscr
     mvcur(lasty,lastx,newy,newx)  actually move cursor
     newwin(lines,cols,begin_y,begin_x) create a new window
     nl()                          set newline mapping
     nocrmode()                    unset cbreak mode
     noecho()                      unset echo mode
     nonl()                        unset newline mapping
     noraw()                       unset raw mode
     overlay(win1,win2)            overlay win1 on win2
     overwrite(win1,win2)          overwrite win1 on top of win2
     printw(fmt,arg1,arg2,...)     printf on stdscr
     raw()                         set raw mode
     refresh()                     make current screen look like stdscr
     resetty()                     reset tty flags to stored value
     savetty()                     stored current tty flags
     scanw(fmt,arg1,arg2,...)      scanf through stdscr
     scroll(win)                   scroll win one line
     scrollok(win,boolf)           set scroll flag
     setterm(name)                 set term variables for name
     standend()                    end standout mode
     standout()                    start standout mode
     subwin(win,lines,cols,begin_y,begin_x) create a subwindow
     touchwin(win)                 "change" all of win
     unctrl(ch)                    printable version of ch
     waddch(win,ch)                add char to win
     waddstr(win,str)              add string to win
     wclear(win)                   clear win
     wclrtobot(win)                clear to bottom of win
     wclrtoeol(win)                clear to end of line on win
     wdelch(win,c)                 delete char from win
     wdeleteln(win)                delete line from win
     werase(win)                   erase win
     wgetch(win)                   get a char through win
     wgetstr(win,str)              get a string through win
     winch(win)                    get char at current (y,x) in win
     winsch(win,c)                 insert char into win
     winsertln(win)                insert line into win
     wmove(win,y,x)                set current (y,x) co-ordinates on win
     wprintw(win,fmt,arg1,arg2,...) printf on win
     wrefresh(win)                 make screen look like win
     wscanw(win,fmt,arg1,arg2,...) scanf through win
     wstandend(win)                end standout mode on win
     wstandout(win)                start standout mode on win

SEE ALSO
     ioctl(2), getenv(3), termcap(3x), tty(4), termcap(5)
     Screen Updating and Cursor Movement Optimization: A Library Package
