
SEND(2)                    UNIX Programmer's Manual                    SEND(2)

NNAAMMEE
     sseenndd, sseennddttoo, sseennddmmssgg - send a message from a socket

SSYYNNOOPPSSIISS
     ##iinncclluuddee <<ssyyss//ttyyppeess..hh>>
     ##iinncclluuddee <<ssyyss//ssoocckkeett..hh>>

     _i_n_t
     sseenndd(_i_n_t _s, _c_o_n_s_t _v_o_i_d _*_m_s_g, _i_n_t _l_e_n, _i_n_t _f_l_a_g_s)

     _i_n_t
     sseennddttoo(_i_n_t _s, _c_o_n_s_t _v_o_i_d _*_m_s_g, _i_n_t _l_e_n, _i_n_t _f_l_a_g_s,
             _c_o_n_s_t _s_t_r_u_c_t _s_o_c_k_a_d_d_r _*_t_o, _i_n_t _t_o_l_e_n)

     _i_n_t
     sseennddmmssgg(_i_n_t _s, _c_o_n_s_t _s_t_r_u_c_t _m_s_g_h_d_r _*_m_s_g, _i_n_t _f_l_a_g_s)

DDEESSCCRRIIPPTTIIOONN
     SSeenndd(), sseennddttoo(), and sseennddmmssgg() are used to transmit a message to another
     socket.  SSeenndd() may be used only when the socket is in a _c_o_n_n_e_c_t_e_d state,
     while sseennddttoo() and sseennddmmssgg() may be used at any time.

     The address of the target is given by _t_o with _t_o_l_e_n specifying its size.
     The length of the message is given by _l_e_n. If the message is too long to
     pass atomically through the underlying protocol, the error EMSGSIZE is
     returned, and the message is not transmitted.

     No indication of failure to deliver is implicit in a sseenndd().  Locally de-
     tected errors are indicated by a return value of -1.

     If no messages space is available at the socket to hold the message to be
     transmitted, then sseenndd() normally blocks, unless the socket has been
     placed in non-blocking I/O mode.  The select(2) call may be used to de-
     termine when it is possible to send more data.

     The _f_l_a_g_s parameter may include one or more of the following:

     #define MSG_OOB        0x1  /* process out-of-band data */
     #define MSG_DONTROUTE  0x4  /* bypass routing, use direct interface */

     The flag MSG_OOB is used to send ``out-of-band'' data on sockets that
     support this notion (e.g.  SOCK_STREAM); the underlying protocol must al-
     so support ``out-of-band'' data.  MSG_DONTROUTE is usually used only by
     diagnostic or routing programs.

     See recv(2) for a description of the _m_s_g_h_d_r structure.

RREETTUURRNN VVAALLUUEESS
     The call returns the number of characters sent, or -1 if an error oc-
     curred.

EERRRROORRSS
     SSeenndd(), sseennddttoo(), and sseennddmmssgg() fail if:

     [EBADF]       An invalid descriptor was specified.

     [ENOTSOCK]    The argument _s is not a socket.

     [EFAULT]      An invalid user space address was specified for a parame-
                   ter.

     [EMSGSIZE]    The socket requires that message be sent atomically, and

                   the size of the message to be sent made this impossible.

     [EWOULDBLOCK]
                   The socket is marked non-blocking and the requested opera-
                   tion would block.

     [ENOBUFS]     The system was unable to allocate an internal buffer.  The
                   operation may succeed when buffers become available.

     [ENOBUFS]     The output queue for a network interface was full.  This
                   generally indicates that the interface has stopped sending,
                   but may be caused by transient congestion.

SSEEEE AALLSSOO
     fcntl(2),  recv(2),  select(2),  getsockopt(2),  socket(2),  write(2)

HHIISSTTOORRYY
     The sseenndd() function call appeared in 4.2BSD.

4.2 Berkeley Distribution         May 1, 1991                                2
