
CONNECT(2)                 UNIX Programmer's Manual                 CONNECT(2)

NNAAMMEE
     ccoonnnneecctt - initiate a connection on a socket

SSYYNNOOPPSSIISS
     ##iinncclluuddee <<ssyyss//ttyyppeess..hh>>
     ##iinncclluuddee <<ssyyss//ssoocckkeett..hh>>

     _i_n_t
     ccoonnnneecctt(_i_n_t _s, _s_t_r_u_c_t _s_o_c_k_a_d_d_r _*_n_a_m_e, _i_n_t _n_a_m_e_l_e_n)

DDEESSCCRRIIPPTTIIOONN
     The parameter _s is a socket.  If it is of type SOCK_DGRAM, this call
     specifies the peer with which the socket is to be associated; this ad-
     dress is that to which datagrams are to be sent, and the only address
     from which datagrams are to be received.  If the socket is of type
     SOCK_STREAM, this call attempts to make a connection to another socket.
     The other socket is specified by _n_a_m_e, which is an address in the commu-
     nications space of the socket.  Each communications space interprets the
     _n_a_m_e parameter in its own way.  Generally, stream sockets may successful-
     ly ccoonnnneecctt() only once; datagram sockets may use ccoonnnneecctt() multiple times
     to change their association.  Datagram sockets may dissolve the associa-
     tion by connecting to an invalid address, such as a null address.

RREETTUURRNN VVAALLUUEESS
     If the connection or binding succeeds, 0 is returned.  Otherwise a -1 is
     returned, and a more specific error code is stored in _e_r_r_n_o.

EERRRROORRSS
     The ccoonnnneecctt() call fails if:

     [EBADF]       _S is not a valid descriptor.

     [ENOTSOCK]    _S is a descriptor for a file, not a socket.

     [EADDRNOTAVAIL]
                   The specified address is not available on this machine.

     [EAFNOSUPPORT]
                   Addresses in the specified address family cannot be used
                   with this socket.

     [EISCONN]     The socket is already connected.

     [ETIMEDOUT]   Connection establishment timed out without establishing a
                   connection.

     [ECONNREFUSED]
                   The attempt to connect was forcefully rejected.

     [ENETUNREACH]
                   The network isn't reachable from this host.

     [EADDRINUSE]  The address is already in use.

     [EFAULT]      The _n_a_m_e parameter specifies an area outside the process
                   address space.

     [EINPROGRESS]
                   The socket is non-blocking and the connection cannot be
                   completed immediately.  It is possible to select(2) for


                   completion by selecting the socket for writing.

     [EALREADY]    The socket is non-blocking and a previous connection at-
                   tempt has not yet been completed.

     The following errors are specific to connecting names in the UNIX domain.
     These errors may not apply in future versions of the UNIX IPC domain.

     [ENOTDIR]     A component of the path prefix is not a directory.

     [ENAMETOOLONG]
                   A component of a pathname exceeded {NAME_MAX} characters,
                   or an entire path name exceeded {PATH_MAX} characters.

     [ENOENT]      The named socket does not exist.

     [EACCES]      Search permission is denied for a component of the path
                   prefix.

     [EACCES]      Write access to the named socket is denied.

     [ELOOP]       Too many symbolic links were encountered in translating the
                   pathname.

SSEEEE AALLSSOO
     accept(2),  select(2),  socket(2),  getsockname(2)

HHIISSTTOORRYY
     The ccoonnnneecctt() function call appeared in 4.2BSD.

4.2 Berkeley Distribution       March 10, 1991                               2
