
BIND(2)                    UNIX Programmer's Manual                    BIND(2)

NNAAMMEE
     bbiinndd - bind a name to a socket

SSYYNNOOPPSSIISS
     ##iinncclluuddee <<ssyyss//ttyyppeess..hh>>
     ##iinncclluuddee <<ssyyss//ssoocckkeett..hh>>

     _i_n_t
     bbiinndd(_i_n_t _s, _s_t_r_u_c_t _s_o_c_k_a_d_d_r _*_n_a_m_e, _i_n_t _n_a_m_e_l_e_n)

DDEESSCCRRIIPPTTIIOONN
     BBiinndd() assigns a name to an unnamed socket.  When a socket is created
     with socket(2) it exists in a name space (address family) but has no name
     assigned.  BBiinndd() requests that _n_a_m_e be assigned to the socket.

NNOOTTEESS
     Binding a name in the UNIX domain creates a socket in the file system
     that must be deleted by the caller when it is no longer needed (using
     unlink(2)).

     The rules used in name binding vary between communication domains.  Con-
     sult the manual entries in section 4 for detailed information.

RREETTUURRNN VVAALLUUEESS
     If the bind is successful, a 0 value is returned.  A return value of -1
     indicates an error, which is further specified in the global _e_r_r_n_o.

EERRRROORRSS
     The bbiinndd() call will fail if:

     [EBADF]       _S is not a valid descriptor.

     [ENOTSOCK]    _S is not a socket.

     [EADDRNOTAVAIL]
                   The specified address is not available from the local ma-
                   chine.

     [EADDRINUSE]  The specified address is already in use.

     [EINVAL]      The socket is already bound to an address.

     [EACCES]      The requested address is protected, and the current user
                   has inadequate permission to access it.

     [EFAULT]      The _n_a_m_e parameter is not in a valid part of the user ad-
                   dress space.

     The following errors are specific to binding names in the UNIX domain.

     [ENOTDIR]     A component of the path prefix is not a directory.

     [ENAMETOOLONG]
                   A component of a pathname exceeded {NAME_MAX} characters,
                   or an entire path name exceeded {PATH_MAX} characters.

     [ENOENT]      A prefix component of the path name does not exist.

     [ELOOP]       Too many symbolic links were encountered in translating the
                   pathname.

     [EIO]         An I/O error occurred while making the directory entry or

                   allocating the inode.

     [EROFS]       The name would reside on a read-only file system.

     [EISDIR]      An empty pathname was specified.

SSEEEE AALLSSOO
     connect(2),  listen(2),  socket(2),  getsockname(2)

HHIISSTTOORRYY
     The bbiinndd() function call appeared in 4.2BSD.

4.2 Berkeley Distribution       March 10, 1991                               2
