;
; MATROX Electronics Systems Ltd.
;
; Sample LISP programs for MG-3D walk-thrus
;
; October 1991
;
; This file contains functions allowing creation of walk-thrus on MG-3D. 
; Using one or two polyline as input, it sends a succession of view points,
; in double-buffering mode. Note that this program works in perspective mode.
;
; To load the AutoLisp program, type:
;
; (load "walk")
;
; There are four options available:
;
; ca: 	This function prompts you for the Focal Lenght, the Twist angle and
;     	the Target point. The successive camera locations are obtained from
;     	a user-selected polyline.
;
; ta: 	This function prompts you for the Focal Lenght, the Twist angle and
;     	the Camera point. The successive target locations are obtained from
;     	a user-selected polyline.
;
; taca:	This function prompts you for the Focal Lenght and the Twist angle.
;	The succesive camera and target points are obtained from a user-
;	selected polyline, in the following manner: 
;		ca[1] = pline_point[1]
;		ta[1] = pline_point[2]
;		ca[2] = pline_point[2]
;		ta[2] = pline_point[3]
;		etc...
;
; cata:	This function prompts you for the Focal Lenght and the Twist angle.
;	The succesive camera and target points are obtained from TWO user-
;	selected polylines. There must be the same number of points in both
;	polylines.
;
; In addition to the above functions, the following one is provided:
;
; reset:This function must be used to reset to board in the proper state
;	if you interrupt one of the above commands by a Ctrl-C.
;
; The functions described above use Matrox Lisp commands described in the 
; Matrox MG-3D AutoCAD Driver Manual: matrdinq, matdblbuff, matvpoint.
;

(defun c:cata()
  (setq f (getreal "Focal length <20.0>: "))
  (if (null f)
    (setq f 20.0)
  )

  (setq tw (getreal "Twist <0.0>: "))
  (if (null tw)
    (setq tw 0.0)
  )

  (prompt "Choose camera and target paths respectively")
  (setq set (ssget))
  (setq ca (ssname set 0))
  (setq ta (ssname set 1))
  (setq cae (entget ca))
  (setq tae (entget ta))

  (if (and
        (= (boole 1 (cdr (assoc 70 cae)) 1) 1)
        (= (boole 1 (cdr (assoc 70 tae)) 1) 1)
      )
    (setq loop T)
    (setq loop nil)
  )

  (setq a 1)
  (setq b 2)

  (setq caorig (entnext ca))
  (setq taorig (entnext ta))

  (setq cv (getvar "CVPORT"))
  (if (= (matrdinq cv) nil)
    (c:matrd)
  )
  (setq mat (list "p" (list "ta" ta) (list "ca" 0.0 0.0 0.0) (list "tw" 0.0) (list "f" f)))
  (matvpoint cv mat)

  (setq l 1)
  (while l
    (setq ca caorig)
    (setq cae (entget ca))
    (setq caf (cdr (assoc 70 cae)))

    (setq ta taorig)
    (setq tae (entget ta))
    (setq taf (cdr (assoc 70 tae)))
   
    (while  (and
              (/= (cdr (assoc 0 cae)) "SEQEND")
              (/= (cdr (assoc 0 tae)) "SEQEND")
            )
      (if (and
            (or
              (> (boole 1 caf 1) 0)
              (> (boole 1 caf 8) 0)
            )
            (or
              (> (boole 1 taf 1) 0)
              (> (boole 1 taf 8) 0)
            )
          )
        (progn
          (setq mat (list (cons "ta" (cdr (assoc 10 tae))) (cons "ca" (cdr (assoc 10 cae)))))
          (matvpoint cv (cons "p" mat))
          (matdblbuf cv a b)
          (setq b (- 3 b))
          (setq a (- 3 a))
        )
      )
      (setq ca (entnext ca))
      (setq cae (entget ca))
      (setq caf (cdr (assoc 70 cae)))
  
      (setq ta (entnext ta))
      (setq tae (entget ta))
      (setq taf (cdr (assoc 70 tae)))
    )
    (if (null loop)
      (setq l nil)
    )
  )
  (setvar "CVPORT" cv)
  (matdblbuf cv 0 0)
  (command "redraw")
  (princ)
)

(defun c:taca()
  (setq f (getreal "Focal length <20.0>: "))
  (if (null f)
    (setq f 20.0)
  )

  (setq tw (getreal "Twist <0.0>: "))
  (if (null tw)
    (setq tw 0.0)
  )

  (prompt "Choose path")
  (setq set (ssget))
  (setq ta (ssname set 0))
  (setq tae (entget ta))
  (if (= (boole 1 (cdr (assoc 70 tae)) 1) 1)
    (setq loop T)
    (setq loop nil)
  )

  (setq a 1)
  (setq b 2)

  (setq taorig (entnext ta))

  (setq cv (getvar "CVPORT"))
  (if (= (matrdinq cv) nil)
    (c:matrd)
  )
  (setq mat (list "p" (list "ta" 0.0 0.0 0.0) (list "ca" 0.0 0.0 1.0) (list "tw" 0.0) (list "f" f)))
  (print (matvpoint cv mat))
  (setq l 1)
  (while l
    (setq ta taorig)
    (setq tae (entget ta))
    (setq taf (cdr (assoc 70 tae)))
    (while (/= (cdr (assoc 0 tae)) "SEQEND")
      (if (or
            (> (boole 1 taf 1) 0)
            (> (boole 1 taf 8) 0)
          )
        (if (null ca)
          (setq ca (cdr (assoc 10 tae)))
          (progn
            (setq tap (cdr (assoc 10 tae)))
            (setq mat (list "p" (cons "ta" tap) (cons "ca" cap)))
            (setq cap tap)
            (matvpoint cv mat)
    
            (matdblbuf cv a b)
            (setq b (- 3 b))
            (setq a (- 3 a))
          )
        )
      )
      (setq ta (entnext ta))
      (setq tae (entget ta))
      (setq taf (cdr (assoc 70 tae)))
    )
    (if (null loop)
      (setq l nil)
    )
  )
  (setvar "CVPORT" cv)
  (matdblbuf cv 0 0)
  (command "redraw")
  (princ)
)

(defun c:ca()
  (setq f (getreal "Focal length <20.0>: "))
  (if (null f)
    (setq f 20.0)
  )

  (setq tw (getreal "Twist <0.0>: "))
  (if (null tw)
    (setq tw 0.0)
  )

  (setq ta (getpoint "Target point <0.0,0.0,0.0>: "))
  (if (null ta)
    (setq ta (list 0.0 0.0 0.0))
    (setq ta (trans ta 1 0))
  )

  (prompt "Choose camera path")
  (setq set (ssget))
  (setq ca (ssname set 0))
  (setq cae (entget ca))
  (if (= (boole 1 (cdr (assoc 70 cae)) 1) 1)
    (setq loop T)
    (setq loop nil)
  )

  (setq a 1)
  (setq b 2)

  (setq caorig (entnext ca))

  (setq cv (getvar "CVPORT"))
  (if (= (matrdinq cv) nil)
    (c:matrd)
  )
  (setq mat (list "p" (list "ta" ta) (list "ca" 0.0 0.0 0.0) (list "tw" 0.0) (list "f" f)))
  (print (matvpoint cv mat))
  (setq l 1)
  (while l
    (setq ca caorig)
    (setq cae (entget ca))
    (setq caf (cdr (assoc 70 cae)))
    (while (/= (cdr (assoc 0 cae)) "SEQEND")
      (if (or
            (> (boole 1 caf 1) 0)
            (> (boole 1 caf 8) 0)
          )
        (progn
          (setq mat (cons "ca" (cdr (assoc 10 cae))))
          (matvpoint cv (list "p" mat))
  
          (matdblbuf cv a b)
          (setq b (- 3 b))
          (setq a (- 3 a))
        )
      )
      (setq ca (entnext ca))
      (setq cae (entget ca))
      (setq caf (cdr (assoc 70 cae)))
    )
    (if (null loop)
      (setq l nil)
    )
  )
  (setvar "CVPORT" cv)
  (matdblbuf cv 0 0)
  (command "redraw")
  (princ)
)

(defun c:ta()
  (setq f (getreal "Focal length <20.0>: "))
  (if (null f)
    (setq f 20.0)
  )

  (setq tw (getreal "Twist <0.0>: "))
  (if (null tw)
    (setq tw 0.0)
  )

  (setq ca (getpoint "Camera point <0.0,0.0,0.0>: "))
  (if (null ca)
    (setq ca (list 0.0 0.0 0.0))
    (setq ca (trans ca 1 0))
  )

  (prompt "Choose target path")
  (setq set (ssget))
  (setq ta (ssname set 0))
  (setq tae (entget ta))
  (if (= (boole 1 (cdr (assoc 70 tae)) 1) 1)
    (setq loop T)
    (setq loop nil)
  )

  (setq a 1)
  (setq b 2)

  (setq taorig (entnext ta))

  (setq cv (getvar "CVPORT"))
  (if (= (matrdinq cv) nil)
    (c:matrd)
  )
  (setq mat (list "p" (list "ta" 0.0 0.0 0.0) (list "ca" ca) (list "tw" 0.0) (list "f" f)))
  (print (matvpoint cv mat))
  (setq l 1)
  (while l
    (setq ta taorig)
    (setq tae (entget ta))
    (setq taf (cdr (assoc 70 tae)))
    (while (/= (cdr (assoc 0 tae)) "SEQEND")
      (if (or
            (> (boole 1 taf 1) 0)
            (> (boole 1 taf 8) 0)
          )
        (progn
          (setq mat (cons "ta" (cdr (assoc 10 tae))))
          (matvpoint cv (list "p" mat))
  
          (matdblbuf cv a b)
          (setq b (- 3 b))
          (setq a (- 3 a))
        )
      )
      (setq ta (entnext ta))
      (setq tae (entget ta))
      (setq taf (cdr (assoc 70 tae)))
    )
    (if (null loop)
      (setq l nil)
    )
  )
  (setvar "CVPORT" cv)
  (matdblbuf cv 0 0)
  (command "redraw")
  (princ)
)

(defun c:reset()
  (matdblbuf cv 0 0)
  (command "redraw")
)

(princ)
