{
-------------------------------------------------------
MIKROBITTI IR-VASTAANOTTO-OHJELMA
-------------------------------------------------------
Ohjelma on kirjoitettu Delphi 3:lla ja kikkailematta mystisten
netist daunattujen komponenttien kanssa. Koko ohjelman
pitisi olla sisllytettyn pakettiin _PAITSI_ ett
se vaati TurboPower Softwaren Async Professional
sarjaportinksittelypaketin. Sen demoversio on saatavilla
osoitteesta www.turbopower.com. Kun sen hakee, ohjelman
pitisi knty. Sarjaportin ksittely on suhtkoht
tuskaton muuttaa toimivaksi mill tahansa paketilla,
sill datan vastaanottoon viitataan vain yhdess
paikassa, josta vastaanotettu data vlittyy ksittelyyn.
Portin valinta ja baudratet ovat kahdessa paikassa,
"Kyt" -napin metodissa ja FormCreatessa, jossa
ladataan ircmd.cfg -tiedosto. Muita viittauksia
sarjaliikenteeseen ei ole.

terv. Panze.
}


unit vastU1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, OoMisc, AdPort, Waint, FmxUtils;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    PCmdNum: TPanel;
    Button1: TButton;
    Button2: TButton;
    Panel3: TPanel;
    Labeljono: TLabel;
    Button3: TButton;
    GroupBox1: TGroupBox;
    CBActive: TCheckBox;
    CBRepeat: TCheckBox;
    RBC1: TRadioButton;
    TBExename: TEdit;
    RBC3: TRadioButton;
    TBSendSerial: TEdit;
    RBC4: TRadioButton;
    RBC5: TRadioButton;
    RBC6: TRadioButton;
    RBC7: TRadioButton;
    RBC8: TRadioButton;
    RBC9: TRadioButton;
    RBC13: TRadioButton;
    RBC14: TRadioButton;
    RBC12: TRadioButton;
    TBTracknum: TEdit;
    Label2: TLabel;
    TBCreatF: TEdit;
    RBC2: TRadioButton;
    RBC10: TRadioButton;
    RBC11: TRadioButton;
    Panel4: TPanel;
    Kom1: TRadioButton;
    Kom2: TRadioButton;
    Kom3: TRadioButton;
    Kom4: TRadioButton;
    Label3: TLabel;
    Komspeed: TEdit;
    Label4: TLabel;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    KomP: TApdComPort;
    Button8: TButton;
    Stop: TButton;
    Label1: TLabel;
    LabelData: TLabel;
    Label5: TLabel;
    TBParams: TEdit;
    OhjausOn: TCheckBox;
    OpenDialog1: TOpenDialog;
    Button9: TButton;
    Label6: TLabel;
    Label7: TLabel;
    Timer1: TTimer;
    procedure Button8Click(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure KomPTriggerAvail(CP: TObject; Count: Word);
    procedure Button7Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure TBExenameChange(Sender: TObject);
    procedure TBParamsChange(Sender: TObject);
    procedure TBCreatFChange(Sender: TObject);
    procedure TBSendSerialChange(Sender: TObject);
    procedure CBActiveClick(Sender: TObject);
    procedure CBRepeatClick(Sender: TObject);
    procedure RBC1Click(Sender: TObject);
    procedure RBC2Click(Sender: TObject);
    procedure RBC3Click(Sender: TObject);
    procedure RBC4Click(Sender: TObject);
    procedure RBC5Click(Sender: TObject);
    procedure RBC6Click(Sender: TObject);
    procedure RBC7Click(Sender: TObject);
    procedure RBC8Click(Sender: TObject);
    procedure RBC9Click(Sender: TObject);
    procedure RBC10Click(Sender: TObject);
    procedure RBC11Click(Sender: TObject);
    procedure RBC12Click(Sender: TObject);
    procedure RBC13Click(Sender: TObject);
    procedure RBC14Click(Sender: TObject);
    procedure TBTracknumChange(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


type ircommandrecord = record

     datalen:integer;
     data:array[0..100] of byte;
     commandtype:integer;
     exename:string[200];
     parameters:string[200];
     createfilename:string[200];
     sendserial:string[200];
     xactive:boolean;
     repeatable:boolean;
     winamptrack:integer;
     mysticint:integer;
     mysticstr:string[30];
     end;



var
  Form1: TForm1;

  recvbuf:array[0..100] of byte;
  teachmode:boolean;

  ircmd:array [1..30] of ircommandrecord;
  curcmd:integer;
  startupdir:string;
  halttime:integer;


implementation

{$R *.DFM}

Procedure AddLabeljono (ch:char);
begin
     Form1.Labeljono.caption := Form1.Labeljono.caption + ch;
End;

Procedure ShowDataScreen (c:integer);
var i:integer;
begin
      with ircmd[c] do with Form1 do begin

           PCmdNum.Caption := 'Komento '+inttostr(c);
           CBActive.Checked := xactive;
           CBRepeat.Checked := repeatable;
           TBExeName.Text := Exename;
           TBParams.Text := parameters;
           TBCreatF.Text := createfilename;
           TBSendSerial.Text := sendserial;


           if commandtype = 1 then RBC1.Checked := True;
           if commandtype = 2 then RBC2.Checked := True;
           if commandtype = 3 then RBC3.Checked := True;
           if commandtype = 4 then RBC4.Checked := True;
           if commandtype = 5 then RBC5.Checked := True;
           if commandtype = 6 then RBC6.Checked := True;
           if commandtype = 7 then RBC7.Checked := True;
           if commandtype = 8 then RBC8.Checked := True;
           if commandtype = 9 then RBC9.Checked := True;
           if commandtype = 10 then RBC10.Checked := True;
           if commandtype = 11 then RBC11.Checked := True;
           if commandtype = 12 then RBC12.Checked := True;
           if commandtype = 13 then RBC13.Checked := True;
           if commandtype = 14 then RBC14.Checked := True;

           Form1.LabelJono.Caption:='Kaukostimen pulssijono: ';
           for i:=1 to datalen do
             if data[i]=0 then addlabeljono ('.')
             else addlabeljono (':');


      end;
end;

function CommandReceived (i:integer):boolean;
var b:boolean;
    j:integer;
begin
     b:=true;
     with IrCmd [i] do begin
          if (datalen > 10) and (xactive) then begin
             for j:=1 to datalen do
                 if recvbuf[100-datalen+j]<>data[j]
                 then b:=false;
          end
          else begin
              b:=false;
          end;
     end;
     CommandReceived := b;
end;


Procedure CheckForCommands;
var i,j:integer;
    f:textfile;
begin
     for i:=1 to 30 do with ircmd[i] do
     begin
          if commandreceived (i)
          then
          begin

               {Form1.KomP.FlushInBuffer;}
               Form1.LabelData.Caption :=
               Form1.LabelData.Caption + 'Komento '+inttostr(i)+'. ';

               If Form1.OhjausOn.Checked then begin

               {Ohjauksien ulosajo}

                   if not repeatable then begin
                      Form1.OhjausOn.Checked:=False;
                      HaltTime:=3;
                   end;

                   Form1.Komp.FlushInBuffer;

                   case commandtype of


                   1: ExecuteFile (exename,parameters,'',SW_SHOW);
                   2: begin
                           assignfile (f,createfilename);
                           rewrite (f);
                           Writeln (f,'MikroBitti IR-vastaanotto-ohjelma on luonut tmn');
                           Writeln (f,'tiedoston kyttjn pyynnn mukaan signaaliksi jollekin');
                           Writeln (f,'muulle ohjelmalle IR-komennnon vastaanottamisen merkiksi.');
                           CloseFile (f);
                   end;

                   3: Form1.KomP.Output := sendserial;
                   4: Waint.Button2;
                   5: Waint.Button4;
                   6: Waint.Forward5;
                   7: Waint.Rewind5;
                   8: Waint.VolumeUp;
                   9: Waint.VolumeDown;
                   10: Waint.Button3;
                   11: Waint.Terminate;
                   13: Waint.Button1;
                   14: Waint.Button5;

                   end;
               end;

          end;
     end;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
     Waint.Button2;
end;

procedure TForm1.StopClick(Sender: TObject);
begin
     Waint.Button4;
end;

procedure TForm1.Button4Click(Sender: TObject);
var x,y:integer;
    f:file of integer;
begin
     If KomP.Open then KomP.Open:=False;
     If Kom1.Checked then Komp.ComNumber:=1;
     If Kom2.Checked then Komp.ComNumber:=2;
     If Kom3.Checked then Komp.ComNumber:=3;
     If Kom4.Checked then Komp.ComNumber:=4;
     Val (Form1.KomSpeed.Text,x,y);
     KomP.Baud:=X;
     KomP.Open:=True;
     chdir (startupdir);
     assignfile (f,'IRCMD.CFG');
     rewrite (f);
     write (f,Komp.Comnumber);
     write (f,x);
     closefile (f);
end;
Function Ones (b:byte):byte;
var n:byte;
begin
     n:=0;
     if (b and 1)<>0 then inc(n);
     if (b and 2)<>0 then inc(n);
     if (b and 4)<>0 then inc(n);
     if (b and 8)<>0 then inc(n);
     if (b and 16)<>0 then inc(n);
     if (b and 32)<>0 then inc(n);
     if (b and 64)<>0 then inc(n);
     if (b and 128)<>0 then inc(n);
     Ones:=n;
end;


Procedure Addrecvbuf (b:byte);
var i:integer;
begin
     for i:=1 to 99 do recvbuf[i]:=recvbuf[i+1];
     recvbuf[100]:=b;
     if teachmode
     then with ircmd[curcmd] do begin
          inc (datalen);
          if datalen>100 then datalen:=100;
          data[datalen]:=b;
          if datalen<100 then
             if b=0 then addlabeljono ('.')
             else addlabeljono (':');




     end;

end;

Procedure PrintRecvBuf;
var i:integer;
    s:string;
begin
     s:='';
     for i:=1 to 100 do
     if recvbuf[i]=0
     then insert ('.',s,200)

     else insert (':',s,200);
     Form1.LabelData.Caption := s;
end;




Procedure KomInput (ch:char);
var b:byte;
begin
     b:=ord (ch);
     b:=ones(b);
     if b>2 then addrecvbuf (0) else addrecvbuf (1);
     PrintRecvBuf;
     if not teachmode then CheckForCommands;
End;

procedure TForm1.KomPTriggerAvail(CP: TObject; Count: Word);

var i,j:integer;

begin

     try
        for i:=1 to Count do begin
            KomInput (KomP.GetChar);
        end;
     except
        on E: Exception do
            begin
                 Form1.LabelData.Caption:='Exception';
            end;
     end;

end;

procedure TForm1.Button7Click(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
     if not teachmode
     then begin
          Button3.Caption := 'Valmis';
          teachmode:=true;
          Form1.LabelJono.Caption:='Kaukostimen pulssijono: ';
          ircmd[curcmd].datalen := 0;

     end
     else begin
          Button3.Caption := 'Opeta';
          teachmode:=false;


     end;

end;



procedure LoadData;
var fi:file;
begin
     assignfile (fi,'ircmd.dat');
     reset (fi,1);
     BlockRead (fi,ircmd,sizeof(ircmd));
     CloseFile (fi);
end;



procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
    f:file of integer;
begin
     Halttime:=0;
     getdir (0,StartupDir);

     curcmd := 1;
     teachmode:=false;
     for i:=1 to 30 do with ircmd[i] do begin
         xactive:=false;
         commandtype := 12;
     end;

     if FileExists ('IRCMD.CFG') then begin
        assignfile (f,'IRCMD.CFG');
        reset (f);
        read (f,i);
        Komp.Comnumber:=i;
        case i of
             1: Kom1.Checked:=True;
             2: Kom2.Checked:=True;
             3: Kom3.Checked:=True;
             4: Kom4.Checked:=True;
        end;

        read (f,i);
        Komp.Baud:=I;
        Komspeed.Text:=inttostr(i);
        Komp.Open:=True;
        closefile (f);
     end;

     if FileExists ('IRCMD.DAT') then LoadData;

     ShowDataScreen (curcmd);

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     dec (curcmd);
     if (curcmd = 0) then curcmd := 30;
     showdatascreen (curcmd);
end;



procedure TForm1.Button2Click(Sender: TObject);
begin
     inc (curcmd);
     if (curcmd = 31) then curcmd := 1;
     showdatascreen (curcmd);

end;

procedure TForm1.TBExenameChange(Sender: TObject);
begin
     ircmd[curcmd].exename:=TBExename.Text;
end;

procedure TForm1.TBParamsChange(Sender: TObject);
begin
     ircmd[curcmd].parameters   :=TBParams.Text;

end;

procedure TForm1.TBCreatFChange(Sender: TObject);
begin
     ircmd[curcmd].createfilename   :=TBCreatF.Text;

end;

procedure TForm1.TBSendSerialChange(Sender: TObject);
begin
     ircmd[curcmd].sendserial   :=TBSendSerial.Text;

end;

procedure TForm1.CBActiveClick(Sender: TObject);
begin
     ircmd[curcmd].xactive   :=CBActive.Checked;

end;

procedure TForm1.CBRepeatClick(Sender: TObject);
begin
     ircmd[curcmd].repeatable   :=CBRepeat.Checked;
end;

procedure TForm1.RBC1Click(Sender: TObject);
begin
     if RBC1.Checked then ircmd[curcmd].commandtype := 1;
end;

procedure TForm1.RBC2Click(Sender: TObject);
begin
     if RBC2.Checked then ircmd[curcmd].commandtype := 2;

end;

procedure TForm1.RBC3Click(Sender: TObject);
begin
     if RBC3.Checked then ircmd[curcmd].commandtype := 3;

end;

procedure TForm1.RBC4Click(Sender: TObject);
begin
     if RBC4.Checked then ircmd[curcmd].commandtype := 4;

end;

procedure TForm1.RBC5Click(Sender: TObject);
begin
     if RBC5.Checked then ircmd[curcmd].commandtype := 5;

end;

procedure TForm1.RBC6Click(Sender: TObject);
begin
     if RBC6.Checked then ircmd[curcmd].commandtype := 6;

end;

procedure TForm1.RBC7Click(Sender: TObject);
begin
     if RBC7.Checked then ircmd[curcmd].commandtype := 7;

end;

procedure TForm1.RBC8Click(Sender: TObject);
begin
     if RBC8.Checked then ircmd[curcmd].commandtype := 8;

end;

procedure TForm1.RBC9Click(Sender: TObject);
begin
     if RBC9.Checked then ircmd[curcmd].commandtype := 9;

end;

procedure TForm1.RBC10Click(Sender: TObject);
begin
     if RBC10.Checked then ircmd[curcmd].commandtype := 10;

end;

procedure TForm1.RBC11Click(Sender: TObject);
begin
     if RBC11.Checked then ircmd[curcmd].commandtype := 11;

end;

procedure TForm1.RBC12Click(Sender: TObject);
begin
     if RBC12.Checked then ircmd[curcmd].commandtype := 12;

end;

procedure TForm1.RBC13Click(Sender: TObject);
begin
     if RBC13.Checked then ircmd[curcmd].commandtype := 13;

end;

procedure TForm1.RBC14Click(Sender: TObject);
begin
     if RBC14.Checked then ircmd[curcmd].commandtype := 14;

end;

procedure TForm1.TBTracknumChange(Sender: TObject);
begin
     ircmd[curcmd].winamptrack  := StrToInt (TBTracknum.Text);

end;

procedure TForm1.Button6Click(Sender: TObject);
var fi:file;
begin
     chdir (startupdir);
     assignfile (fi,'ircmd.dat');
     rewrite (fi,1);
     BlockWrite (fi,ircmd,sizeof(ircmd));
     CloseFile (fi);
end;


procedure TForm1.Button5Click(Sender: TObject);
var fi:file;
begin
     assignfile (fi,'ircmd.dat');
     reset (fi,1);
     BlockRead (fi,ircmd,sizeof(ircmd));
     CloseFile (fi);


end;

procedure TForm1.Button9Click(Sender: TObject);
begin
     OpenDialog1.Execute;
     TBExename.Text := OpenDialog1.Filename;
     ircmd[curcmd].exename:=OpenDialog1.FileName;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
     if halttime>0 then dec (halttime);
     if halttime=0 then OhjausOn.Checked := true;
end;

end.
