Option Explicit

Global Const LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
Global Const NUMBERS = "0123456789"

Global Const PWDSTYLE_ABC = 1
Global Const PWDSTYLE_123 = 2
Global Const PWDSTYLE_ABC123 = 3

Type PWDINFO_TYPE
    Name As String
    Description As String
    Phone As String
    HowMany As Integer
    Length As Integer
    Style As Integer
End Type

Function MakePassword (ByVal Length As Integer, ByVal Style As Integer) As String
    Dim strSource As String
    Dim strDest As String
    Dim i As Integer
    Dim iPos As Integer
    Dim ch As String * 1
    
    Select Case Style
        Case PWDSTYLE_ABC
            strSource = LETTERS
        Case PWDSTYLE_123
            strSource = NUMBERS
        Case PWDSTYLE_ABC123
            strSource = LETTERS & NUMBERS
    End Select

    strDest = ""
    For i = 1 To Length
        iPos = Int(Len(strSource) * Rnd + 1)
        ch = Mid$(strSource, iPos, 1)
        strDest = strDest & ch
    Next i
    
    MakePassword = strDest
End Function

Sub MakePwdList (List() As String, ByVal Count As Integer, ByVal Length As Integer, ByVal Style As Integer)
    Dim i As Integer

    ReDim List(Count)
    For i = 0 To Count - 1
        List(i) = MakePassword(Length, Style)
    Next i
End Sub

