package jere.applets.onthisday;

import java.awt.*;
import java.util.*;
import java.text.*;


/**
 * Presents the events related to some topic.
 *
 * @author Jere Kpyaho
 * @version $Revision$
 */
public class EventCanvas extends java.awt.Canvas {

    private Vector eventList;
    private FontMetrics fontMetrics;

    /**
     * Constructs an empty event canvas.
     */
    public EventCanvas() {
        this(new Vector());
    }
    
    /**
     * Constructs an event canvas with a list of events.
     *
     * @param eventList The list of events
     */
    public EventCanvas(Vector eventList) {
        super();
        this.setFont(new Font("SansSerif", Font.PLAIN, 12));

        //this.setBackground(new Color(0x00, 0xcc, 0x00));

        this.eventList = eventList;

        Font f = this.getFont();
        if (f == null) {
            System.err.println("EventCanvas: font is null!");
        }

        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void paint(Graphics g) {
        //g.setColor(Color.black);
        g.setColor(this.getForeground());

        String message = "";

        int spaceWidth = fontMetrics.charWidth(' ');
        int x = spaceWidth;
        int y = 0; //fontMetrics.getHeight();


    	Enumeration e = eventList.elements();
    	while (e.hasMoreElements()) {
    	    x = spaceWidth;
    	    y += fontMetrics.getHeight();

    	    Event event = (Event) e.nextElement();

    	    message = Integer.toString(event.getYear()) + ": " + 
                event.getDescription();

    	    // Wrap lines the Java 1.1 way, using java.text.BreakIterator.
    	    // Some of this code comes from "The Java Tutorial".

    	    BreakIterator lineIterator = BreakIterator.getLineInstance(Locale.getDefault());
    	    lineIterator.setText(message);

    	    int start = lineIterator.first();
    	    int end = lineIterator.next();
    	    int lineLength = 0;

    	    int maxLength = this.getSize().width;
    
    	    while (end != BreakIterator.DONE) {
        		String word = message.substring(start, end);
        		int wordWidth = fontMetrics.stringWidth(word);
        		lineLength = lineLength + wordWidth;
        		if (lineLength >= maxLength) {
        		    x = spaceWidth;
        		    y += fontMetrics.getHeight();
        		    lineLength = wordWidth;
        		}
        		g.drawString(word, x, y);
        		x += wordWidth;
        		start = end;
        		end = lineIterator.next();
      	    } // while (end...)
        } // while (e.hasMore...)
    }

    public void setEventList(Vector eventList) {
        this.eventList = eventList;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        // Must fit at least 40 characters, 10 lines
        return new Dimension(40 * fontMetrics.charWidth('k') , 10 * fontMetrics.getHeight());
    }

} // EventCanvas

