package jere.applets.onthisday;

/**
 * Interface to directly compare objects for sorting purposes.
 *
 * @author Jere Kpyaho
 * @version $Revision$
 */
public interface Sortable {
    /**
     * Compare this object to another and return a value that 
     * indicates their relative order.
     *  
     * @param other Reference to the other object
     * @return If this object comes before the other, return negative.
     *         If the objects are equal, return zero.
     *         If this object comes after the other, return positive.
     */
    public int compareTo(Object other);
}


