/*
 TODO:
 - Make internationalizable
 - Clean up the code!
 - Add font parameters
*/

package jere.applets.onthisday;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.text.*;

import jere.applets.AppletParameter;

// Import SAX and Aelfred classes
import org.xml.sax.*;
import com.microstar.xml.*;

/**
 * Applet to display historical events related to this date.
 *
 * @author Jere Kpyaho
 * @version $Revision$
 */
public class OnThisDay extends Applet implements ItemListener {
    // Set to true if you want debug information on the console
    public static final boolean DEBUG = true;
    public static final boolean USE_RESOURCE_FILE = true;

    EventFinder eventFinder;  // SAX HandlerBase descendant to filter events
    Label dateLabel;          // label to show today's date
    List topicList;           // list of topics
    Date filterDate;          // the date by which to filter events
    Hashtable events;         // all the events
    Vector topics;            // all the topics, used as keys to the events hashtable
    EventCanvas eventCanvas;  // the canvas to present the events in

    /**
     * Initializes the applet.
     */
    public void init() {
        System.out.println(this.getAppletInfo());

        String dateString = this.getParameter("date");
        if (dateString == null) {
            filterDate = new Date();  // get today's date
        }
        else { // extract the month and day
            int month = Integer.parseInt(dateString.substring(0, 2));
            int day = Integer.parseInt(dateString.substring(3, 5));

            // The following code dies with the Microsoft Java VM for Windows,
            // at least "4.0 Release 4.79.0.2435".
            //Calendar cal = Calendar.getInstance();
            //cal.setTime(new Date());
            //cal.set(Calendar.MONTH, month - 1);
            //cal.set(Calendar.DATE, day);
            // FIXME: check the parameter values
            //filterDate = cal.getTime();

            // This is a MS JVM bug workaround which uses deprecated code.
            filterDate = new Date();
            filterDate.setMonth(month - 1);
            filterDate.setDate(day);

            System.out.println("month = " + month + ", day = " + day);
        }

        this.setLayout(new BorderLayout());


        // Get topic list foreground color. Defaults to black.
        Color topicForegroundColor = AppletParameter.getColor(this, "topicfgcolor", Color.black);

        // Get topic list background color. Defaults to orange.
        Color topicBackgroundColor = AppletParameter.getColor(this, "topicbgcolor", new Color(0xff, 0xff, 0x99));

        // Create the list of topics and set its colors.
        topicList = new List(10);
        topicList.setForeground(topicForegroundColor);
        topicList.setBackground(topicBackgroundColor);
        topicList.setFont(new Font("SansSerif", Font.PLAIN, 12));
        topicList.addItemListener(this);

        // Format the filter date and put in a label:
        //SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE, d. MMMM");
        DateFormat df = DateFormat.getDateInstance(DateFormat.FULL);
        StringBuffer buf = new StringBuffer(df.format(filterDate));

        // Had to change because of wrong non-Finnish format.
        // Now includes the year as well, but what the hell.

        // Workaround for Finnish locale date formatting bug.
        // Adds the missing "ta" suffix for the month name.
        //if (Locale.getDefault().toString().startsWith("fi_FI")) {
        //    buf.append("ta");
        //}

        if (Locale.getDefault().toString().startsWith("fi_FI")) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEEE, ");
            buf.insert(0, sdf.format(filterDate));
        }

        // Make the sentence begin with a capital letter.
        char firstChar = buf.charAt(0);
        buf.setCharAt(0, Character.toUpperCase(firstChar));


        // Get date label foreground color. Defaults to black.
        Color dateForegroundColor = AppletParameter.getColor(this, "datefgcolor", Color.black);

        // Get date label background color. Defaults to orange.
        Color dateBackgroundColor = AppletParameter.getColor(this, "datebgcolor", Color.orange);

        dateLabel = new Label(buf.toString());
        dateLabel.setFont(new Font("SansSerif", Font.BOLD, 12));
        dateLabel.setBackground(dateBackgroundColor);
        dateLabel.setForeground(dateForegroundColor);


        eventCanvas = new EventCanvas();

        // Get event canvas foreground color. Defaults to white.
        Color eventForegroundColor = AppletParameter.getColor(this, "eventfgcolor", Color.white);

        // Get event canvas background color. Defaults to green.
        Color eventBackgroundColor = AppletParameter.getColor(this, "eventbgcolor", new Color(0x00, 0xcc, 0x00));

        eventCanvas.setBackground(eventBackgroundColor);
        eventCanvas.setForeground(eventForegroundColor);
        

        // Add the components to the applet
        this.add(BorderLayout.NORTH, dateLabel);
        this.add(BorderLayout.CENTER, eventCanvas);
        this.add(BorderLayout.WEST, topicList);

        this.showStatus("Loading events...");

        String dataFileName = this.getParameter("datafile");
        if (dataFileName != null) {
            if (DEBUG) {
                System.err.println("datafile = " + dataFileName);
            }

            BufferedReader reader = null;
            InputStream in = null;

            if (USE_RESOURCE_FILE) {
                // Applet security problem workaround starts:
                in = getClass().getResourceAsStream("/" + dataFileName);
                if (in == null) {
                    System.err.println("Input stream from resource file is null!");
                }

                reader = new BufferedReader(new InputStreamReader(in));
                if (reader == null) {
                    System.err.println("Reader is null!");
                }
            }
            else {  // original code using regular file
                // The following code gives random applet security exceptions
                // in Netscape. Attempt workaround by making the event data
                // file a "resource file" and putting it inside the JAR.
                // The file extension also needs to be changed to have a
                // "Netscape approved" extension. Easiest is ".txt".

                URL dataFileURL = null;
                try {
                    dataFileURL = new URL(this.getDocumentBase(), dataFileName);
                    dataFileURL = new URL(this.getCodeBase(), dataFileName);
                }
                catch (MalformedURLException mue) {
                    this.showStatus("Bad data file URL");
                }

                if (dataFileURL != null) {
                    try {
                        in = dataFileURL.openStream();
                        reader = new BufferedReader(new InputStreamReader(in));
                    }
                    catch (FileNotFoundException fnfe) {
                        this.showStatus("Event data file not found");
                        System.err.println(fnfe);
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        System.err.println(ioe);
                        ioe.printStackTrace();
                    }
                    catch (Exception e) {
                        this.showStatus("Error reading event data file");
                        System.err.println(e);
                        e.printStackTrace();
                    }
                }
            }

            eventFinder = new EventFinder(filterDate);
            try {
                //Class.forName("org.apache.xerces.parsers.SAXParser");
                //Parser parser = ParserFactory.makeParser("org.apache.xerces.parsers.SAXParser");
                //Parser parser = new org.apache.xerces.parsers.SAXParser();

                // Load the XML parser class. Can't use SAX's ParserFactory
                // because of applet restrictions (I think).
                org.xml.sax.Parser parser = new com.microstar.xml.SAXDriver();

                parser.setDocumentHandler(eventFinder);
                parser.setErrorHandler(new ErrorHandler());
                parser.parse(new InputSource(reader));

                events = eventFinder.getEvents();
                topics = eventFinder.getTopics();
            }
            catch (SAXParseException spe) {
                System.err.println(spe);
                spe.printStackTrace();
            }
            catch (SAXException sex) {
                System.err.println(sex);
                sex.printStackTrace();
            }
            catch (Exception ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
        }
        else {
            if (DEBUG) {
                System.err.println("No data file specified!");
            }
        }

        //System.out.println(topics);
        //System.out.println(events);

        String topic = "";
        Hashtable topicNames = eventFinder.getTopicNames();
        if (topics != null) {
            Enumeration e = topics.elements();
            while (e.hasMoreElements()) {
                topic = (String) e.nextElement();
                String topicName = (String) topicNames.get(topic);
                if (topicName != null) {
                    topicList.add(topicName);
                }
            }

            if (topicList.getItemCount() > 1) {
                topicList.select(0); // select the first element
                // let the event handling code do the rest

                // FIXME: how do we make the selection bite,
                // i.e. should we simulate an ItemEvent, like this:
                ItemEvent ie = new ItemEvent(topicList, ItemEvent.ITEM_STATE_CHANGED,
                                             topic, ItemEvent.SELECTED);
                this.itemStateChanged(ie);
            }
        }
    } // init()

    /**
     * Called when a list item is selected or deselected.
     *
     * @param e The ItemEvent received
     */
    public void itemStateChanged(ItemEvent e) {
        //System.out.println("ItemEvent id = " + e.getID());

        List source = (List) e.getItemSelectable();
        if (source == topicList) {
            // Get the number of the selected item
            // and fetch its key from the topic vector.
            int selected = topicList.getSelectedIndex();

            // Defensive coding; some versions of IE4 return -1
            if (selected >= 0) {
                String key = (String) topics.elementAt(selected);

                Vector eventList = (Vector) events.get(key);
                EventSorter.sort(eventList);

                // Set the event canvas's event list and repaint it.
                eventCanvas.setEventList(eventList);
                eventCanvas.repaint();
            }
        }
    }

    /**
     * Returns information about the applet.
     *
     * @return Applet information string
     */
    public String getAppletInfo() {
        return "On This Day v0.3\nCopyright \u00a9 2000 Jere K\u00e4pyaho";
    }

    /**
     * Returns information about the applet parameters.
     *
     * @return Array of string arrays containing parameter names,
     * types, and descriptions
     */
    public String[][] getParameterInfo() {
        return info;
    }

    private String[][] info = {
        { "datafile", "string", "Name of data file" },
        { "date", "string MM-DD", "Event filter date (for testing)" }
    };
}

