/*
 * Decompiled with CFR 0.152.
 */
package jere.applets.onthisday;

import java.util.Date;
import java.util.EmptyStackException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import jere.applets.onthisday.DateFilter;
import jere.applets.onthisday.Event;
import jere.applets.onthisday.EventFilter;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;

public class EventFinder
extends HandlerBase {
    private Stack eventStack = new Stack();
    private Stack topicStack = new Stack();
    private boolean isEvent = false;
    private boolean isTopic = false;
    private Date filterDate;
    private Vector topics;
    private Hashtable events;
    private Hashtable topicNames;

    public EventFinder(Date filterDate) {
        this.filterDate = filterDate;
        this.topics = new Vector(10);
        this.events = new Hashtable();
        this.topicNames = new Hashtable();
    }

    public void startElement(String element, AttributeList attrlist) {
        if (element.equals("otdml")) {
            String syslang;
            String lang = attrlist.getValue("lang");
            if (!lang.equals(syslang = Locale.getDefault().toString().substring(0, 2))) {
                System.err.println(String.valueOf(String.valueOf(String.valueOf("Warning: events language = ").concat(String.valueOf(lang))).concat(String.valueOf(", system language = "))).concat(String.valueOf(syslang)));
            }
        } else if (element.equals("event")) {
            this.isEvent = true;
            String dateString = attrlist.getValue("date");
            String topic = attrlist.getValue("topic");
            int year = Integer.parseInt(dateString.substring(0, 4));
            int month = Integer.parseInt(dateString.substring(5, 7));
            int day = Integer.parseInt(dateString.substring(8, 10));
            GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
            Event event = new Event(calendar.getTime(), topic, "(none)");
            this.eventStack.push(event);
        } else if (element.equals("topic")) {
            this.isTopic = true;
            String nameString = attrlist.getValue("name");
            this.topicStack.push(nameString);
        }
    }

    public void characters(char[] chars, int start, int length) {
        if (this.isEvent) {
            String text = new String(chars, start, length);
            try {
                Event event = (Event)this.eventStack.peek();
                event.setDescription(text);
            }
            catch (EmptyStackException ese) {
                System.err.println("No elements to peek");
                System.err.println(ese);
            }
        } else if (this.isTopic) {
            String text = new String(chars, start, length);
            try {
                String name = (String)this.topicStack.peek();
                this.topicStack.push(text);
            }
            catch (EmptyStackException ese) {
                System.err.println("No topics to peek");
                System.err.println(ese);
            }
        }
    }

    public void endElement(String element) {
        if (element.equals("event")) {
            this.isEvent = false;
            Event event = null;
            try {
                event = (Event)this.eventStack.pop();
                if (this.filterDate == null) {
                    System.err.println("Filter date is null!");
                }
                String topic = event.getTopic();
                DateFilter filter = new DateFilter(this.filterDate);
                if (((EventFilter)filter).accepts(event)) {
                    Vector<Event> topicVector = (Vector<Event>)this.events.get(topic);
                    if (topicVector == null) {
                        topicVector = new Vector<Event>(10);
                        this.events.put(topic, topicVector);
                        this.topics.addElement(topic);
                    }
                    topicVector.addElement(event);
                }
            }
            catch (EmptyStackException ese) {
                System.err.println("No elements to pop");
                System.err.println(ese);
            }
        } else if (element.equals("topic")) {
            this.isTopic = false;
            String description = (String)this.topicStack.pop();
            String name = (String)this.topicStack.pop();
            this.topicNames.put(name, description);
        }
    }

    public Hashtable getEvents() {
        return this.events;
    }

    public Vector getTopics() {
        return this.topics;
    }

    public Hashtable getTopicNames() {
        return this.topicNames;
    }
}

