/*
 * Decompiled with CFR 0.152.
 */
package jere.applets;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class AppletParameter {
    private static Hashtable standardColors = new Hashtable(16);

    public static String getString(Applet applet, String name, String defaultValue) {
        String value = applet.getParameter(name);
        return value != null ? value : defaultValue;
    }

    public static int getInteger(Applet applet, String name, int defaultValue) {
        String stringValue = applet.getParameter(name);
        int value = defaultValue;
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException nfe) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static Color getColor(Applet applet, String name, Color defaultValue) {
        Color colorValue = null;
        String colorString = applet.getParameter(name);
        if (colorString != null) {
            if (colorString.charAt(0) == '#' && colorString.length() == 7) {
                try {
                    colorValue = Color.decode(String.valueOf("0x").concat(String.valueOf(colorString.substring(1))));
                }
                catch (NumberFormatException nfe) {
                    applet.showStatus(String.valueOf(String.valueOf("Bad parameter: '").concat(String.valueOf(name))).concat(String.valueOf("'. Using default value.")));
                    colorValue = defaultValue;
                }
            } else {
                colorValue = (Color)standardColors.get(colorString.toLowerCase());
            }
        } else {
            colorValue = defaultValue;
        }
        return colorValue;
    }

    public static URL getURL(Applet applet, String name, URL defaultValue) {
        URL url = null;
        String urlString = applet.getParameter(name);
        if (urlString != null) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                applet.showStatus(String.valueOf(String.valueOf("Bad parameter: '").concat(String.valueOf(name))).concat(String.valueOf("'. Using default value.")));
                url = defaultValue;
            }
        } else {
            url = defaultValue;
        }
        return url;
    }

    public static Font getFont(Applet applet, String name, Font defaultValue) {
        Font font = null;
        String fontString = applet.getParameter(name);
        font = fontString != null ? Font.decode(fontString) : defaultValue;
        return font;
    }

    static {
        standardColors.put("black", Color.black);
        standardColors.put("silver", new Color(192, 192, 192));
        standardColors.put("gray", new Color(128, 128, 128));
        standardColors.put("white", Color.white);
        standardColors.put("maroon", new Color(128, 0, 0));
        standardColors.put("red", Color.red);
        standardColors.put("purple", new Color(128, 0, 128));
        standardColors.put("fuchsia", new Color(255, 0, 255));
        standardColors.put("green", Color.green);
        standardColors.put("lime", new Color(0, 255, 0));
        standardColors.put("olive", new Color(128, 128, 0));
        standardColors.put("yellow", Color.yellow);
        standardColors.put("navy", new Color(0, 0, 128));
        standardColors.put("blue", Color.blue);
        standardColors.put("teal", new Color(0, 128, 128));
        standardColors.put("aqua", new Color(0, 255, 255));
    }
}

