/*
 * Decompiled with CFR 0.152.
 */
package jere.applets.onthisday;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import jere.applets.onthisday.Event;

public class EventCanvas
extends Canvas {
    private Vector eventList;
    private FontMetrics fontMetrics;

    public EventCanvas() {
        this(new Vector());
    }

    public EventCanvas(Vector eventList) {
        this.setFont(new Font("SansSerif", 0, 12));
        this.eventList = eventList;
        Font f = this.getFont();
        if (f == null) {
            System.err.println("EventCanvas: font is null!");
        }
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void paint(Graphics g) {
        int spaceWidth;
        g.setColor(this.getForeground());
        String message = "";
        int x = spaceWidth = this.fontMetrics.charWidth(' ');
        int y = 0;
        Enumeration e = this.eventList.elements();
        while (e.hasMoreElements()) {
            x = spaceWidth;
            y += this.fontMetrics.getHeight();
            Event event = (Event)e.nextElement();
            message = String.valueOf(String.valueOf(Integer.toString(event.getYear())).concat(String.valueOf(": "))).concat(String.valueOf(event.getDescription()));
            BreakIterator lineIterator = BreakIterator.getLineInstance(Locale.getDefault());
            lineIterator.setText(message);
            int start = lineIterator.first();
            int end = lineIterator.next();
            int lineLength = 0;
            int maxLength = this.getSize().width;
            while (end != -1) {
                String word = message.substring(start, end);
                int wordWidth = this.fontMetrics.stringWidth(word);
                if ((lineLength += wordWidth) >= maxLength) {
                    x = spaceWidth;
                    y += this.fontMetrics.getHeight();
                    lineLength = wordWidth;
                }
                g.drawString(word, x, y);
                x += wordWidth;
                start = end;
                end = lineIterator.next();
            }
        }
    }

    public void setEventList(Vector eventList) {
        this.eventList = eventList;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(40 * this.fontMetrics.charWidth('k'), 10 * this.fontMetrics.getHeight());
    }
}

