#include <stdio.h>
#include <stdlib.h>
#include "list1.h"

void TryLists( void )
{
    List L;
    ListNodePtr p;
    int count;

    printf( "\n*** Linkitetyn listan testaus ***\n" );
    printf( "\nTehdn uusi lista: " );
    L = ListCreate();
    ListPrint( L );
    printf( "\nListn alkiot 12, 12, 12, 11, 46, 24, 89 ja 25: " );
    ListAppend( &L, 12 );
    ListAppend( &L, 12 );
    ListAppend( &L, 12 );
    ListAppend( &L, 11 );
    ListAppend( &L, 46 );
    ListAppend( &L, 24 );
    ListAppend( &L, 89 );
    ListAppend( &L, 25 );
    ListPrint( L );
    printf( "\n" );

    p = ListFind( L, 66 );  /* etsi olematonta */
    if ( NULL == p )
        printf( "OK: ei lytynyt 66:tta eik pitnytkn\n" );
    else
        printf( "Virhe: lytyi jotain mit ei pitisi!\n" );

    p = ListFind( L, 12 );  /* etsi ensimmist */
    if ( NULL == p )
        printf( "Virhe: ensimmist alkiota ei lytynyt\n" );
    else
        printf( "OK: 12 lytyi\n" );

    p = ListFind( L, 25 );  /* etsi viimeist */
    if ( NULL == p )
        printf( "Virhe: viimeist alkiota ei lytynyt\n" );
    else
        printf( "OK: 25 lytyi\n" );

    p = ListFind( L, 46 );  /* etsi keskelt */
    if ( NULL == p )
        printf( "Virhe: keskell olevaa alkiota ei lytynyt\n" );
    else
        printf( "OK: 46 lytyi\n" );

    printf( "Poistetaan kaikki 12:set... " );
    count = ListDelete( &L, 12 );
    printf( "%d alkio%s poistettu\n", count, (count != 1) ? "ta" : "" );

    printf( "Poistetaan kaikki 24:t... " );
    count = ListDelete( &L, 24 );
    printf( "%d alkio%s poistettu\n", count, (count != 1) ? "ta" : "" );

    printf( "Poistetaan kaikki 99:t... " );
    count = ListDelete( &L, 99 );
    printf( "%d alkio%s poistettu\n", count, (count != 1) ? "ta" : "" );

    printf( "Listn alkiot 8 ja 5 listaan... " );
    ListInsert( &L, 8 );
    ListInsert( &L, 5 );
    ListPrint( L );

    printf( "\nListn alkio 42 alkion 11 pern... " );
    ListInsertAfter( &L, 42, 11 );
    ListPrint( L );

    printf( "\nListn alkio 6 alkion 5 pern... " );
    ListInsertAfter( &L, 6, 5 );
    ListPrint( L );

    printf( "\nListn alkio 27 alkion 25 pern... " );
    ListInsertAfter( &L, 27, 25 );
    ListPrint( L );
    printf( "\n" );

    printf( "Tuhotaan lista... " );
    ListDestroy( &L );
    ListPrint( L );
    printf( "\n\n" );
}

int main( void )
{
    List L;
    int count;

    TryLists();

#if 0   /* vaihtoehtoinen testauskoodi */
    L = ListCreate();
    count = 0;
    while ( count < 10000 )
    {
        if ( ListAppend( &L, rand() % 100 ) )
        {
            /* printf( "." ); */
            count++;
        }
        else break;
    }

    printf( "\ncount = %d\n", count );
    ListPrint( L );
    ListDestroy( &L );
#endif

    return 0;
}
