/* LIST1.C -- Linkitetyn listan yllpitorutiinit */

#include <stdio.h>
#include <stdlib.h>
#include "list1.h"

/* ListCreate: tee uusi, tyhj lista */
List ListCreate( void )
{
    return NULL;
}

/* ListGetLast: palauta osoitin listan 'L' viimeiseen alkioon */
ListNodePtr ListGetLast( List L )
{
    ListNodePtr p, prev, curr;

    if ( NULL == L )
       return NULL;
    else
    {
        prev = L;
        curr = L;
        while ( NULL != curr )
        {
            prev = curr;
            curr = curr->next;
        }
        return prev;
    }
}

/* ListAppend: lis avain 'k' listan 'L' loppuun */
Boolean ListAppend( List *L, ListKey k )
{
    ListNodePtr ListGetLast( List );
    ListNodePtr p, last;

    p = (ListNodePtr) malloc( sizeof(ListNode) );
    if ( NULL == p ) return FALSE;
    p->key = k;
    p->next = NULL;

    if ( *L == NULL )
       *L = p;
    else
    {
        last = ListGetLast( *L );
        last->next = p;
    }
    return TRUE;
}

/* ListFind: etsi (ensimminen) avain 'k' listasta 'L' */
ListNodePtr ListFind( List L, ListKey k )
{
    ListNodePtr p;
    Boolean found;

    p = NULL;
    found = FALSE;
    while ( (NULL != L) && (!found) )
    {
        if ( L->key == k )
        {
            found = TRUE;
            p = L;
        }
        else
            L = L->next;
    }
    return p;
}

/* ListDelete: poista kaikki avaimet 'k' listasta 'L'. */
int ListDelete( List *L, ListKey k )
{
    ListNodePtr p, tmp, prev;
    int count;

    p = *L;
    count = 0;

    /* toista niin kauan kuin listan ensimminen alkio on 'k': */
    while ( (NULL != p) && (p->key == k) )
    {
        tmp = p->next;
        free( p ); count++;
        p = tmp;
    }

    *L = p;   /* pivit listan alkupn osoitin silt varalta */
              /* ett lista on tyhjentynyt */
    prev = p;
    p = p->next;
    while ( NULL != p )  /* ky lista lpi */
    {
        if ( k == p->key )  /* lytyi */
        {
            prev->next = p->next;
            free( p ); count++;
            p = prev->next;
        }
        else
        {
            prev = p;
            p = p->next;
        }
    }

    return count;  /* palauta poistettujen alkioiden lukumr */
}

/* ListInsert: lis avain 'k' listan 'L' alkuun */
Boolean ListInsert( List *L, ListKey k )
{
    ListNodePtr p;

    p = (ListNodePtr) malloc( sizeof(ListNode) );
    if ( NULL == p ) return FALSE;
    p->key = k;
    p->next = *L;
    *L = p;
    return TRUE;
}

/* ListInsertAfter: lis avain 'k' listaan 'L' alkion 'afterKey' pern */
Boolean ListInsertAfter( List *L, ListKey k, ListKey afterKey )
{
    ListNodePtr a, p;

    a = ListFind( *L, afterKey );
    if ( NULL != a )
    {
        p = (ListNodePtr) malloc( sizeof(ListNode) );
        if ( NULL == p ) return FALSE;
        p->key = k;
        p->next = a->next;
        a->next = p;
        return TRUE;
    }
    return FALSE;
}

/* ListDestroy: tuhoa kaikki listan 'L' alkiot */
void ListDestroy( List *L )
{
    ListNodePtr p, tmp;

    p = *L;
    while ( p != NULL )
    {
        tmp = p;
        p = p->next;
        free( tmp );
    }
    *L = NULL;
}

/* ListPrint: tulosta listan 'L' sislt stdout-laitteelle */
void ListPrint( List L )
{
    printf( "( " );
    while ( L != NULL )
    {
        printf( "%d ", L->key );
        L = L->next;
    }
    printf( ")" );
}
