unit DiscEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFrmDiscEditor = class(TForm)
    LblArtist: TLabel;
    LblTitle: TLabel;
    TxtArtist: TEdit;
    TxtTitle: TEdit;
    BtnOK: TButton;
    BtnCancel: TButton;
    LblTrack: TLabel;
    TxtTrack: TEdit;
    LblTrackList: TLabel;
    LstTracks: TListBox;
    BtnUpdate: TButton;
    procedure FormActivate(Sender: TObject);
    procedure LstTracksClick(Sender: TObject);
    procedure BtnUpdateClick(Sender: TObject);
    procedure TxtArtistChange(Sender: TObject);
    procedure TxtTitleChange(Sender: TObject);
  private
    { Private declarations }
    Changed: Boolean;
  public
    { Public declarations }
    function HasChanged: Boolean;
  end;

var
  FrmDiscEditor: TFrmDiscEditor;

implementation

{$R *.DFM}

procedure TFrmDiscEditor.FormActivate(Sender: TObject);
begin
  Changed := False;
  LstTracks.ItemIndex := 0;
  TxtTrack.Text := LstTracks.Items[0];
end;

procedure TFrmDiscEditor.LstTracksClick(Sender: TObject);
begin
  TxtTrack.Text := LstTracks.Items[LstTracks.ItemIndex];
end;

procedure TFrmDiscEditor.BtnUpdateClick(Sender: TObject);
var
  N: Integer;
begin
  if TxtTrack.Text <> '' then
  begin
    N := LstTracks.ItemIndex;
    LstTracks.Items.Delete(N);
    LstTracks.Items.Insert(N, TxtTrack.Text);
    Changed := True;
  end;
end;

procedure TFrmDiscEditor.TxtArtistChange(Sender: TObject);
begin
  Changed := True;
end;

function TFrmDiscEditor.HasChanged: Boolean;
begin
  Result := Changed;
end;

procedure TFrmDiscEditor.TxtTitleChange(Sender: TObject);
begin
  Changed := True;
end;

end.
