unit Test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Digital, StdCtrls, ExtCtrls;

type
  TTestForm = class(TForm)
    Label1: TLabel;
    Panel1: TPanel;
    DigitalDisplay1: TDigitalDisplay;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    MyDigits: TBitmap;
  public
    //Readout: TDigitalDisplay;
  end;

var
  TestForm: TTestForm;

implementation

uses
  Registry;

{$R *.DFM}

procedure TTestForm.FormCreate(Sender: TObject);
var
  Reg: TRegistry;
  DataSize: Integer;
  Data: Longint;
begin
  MyDigits := TBitmap.Create;
  // Uncomment any one of these for testing:
  MyDigits.LoadFromFile('7seg.bmp');
  //MyDigits.LoadFromFile('sbgs.bmp');
  //MyDigits.LoadFromFile('computer.bmp');
  //MyDigits.LoadFromFile('pdr.bmp');

{*******}
{ This code is used to test the component
  before it is installed in the palette. }
{
  Readout := TDigitalDisplay.Create(Self);
  with Readout do
  begin
    Parent := Self;
    Top := 10;
    Left := 10;
    DigitCount := 3;
    Digits := MyDigits;
    Value := 100;
  end;
}
{*******}

  try
    Reg := TRegistry.Create;
    Reg.RootKey := HKEY_DYN_DATA;

    try
      Reg.OpenKey('PerfStats\StartStat', False);
      DataSize := Reg.GetDataSize('KERNEL\CPUUsage');
      Reg.ReadBinaryData('KERNEL\CPUUsage', Data, DataSize);
    finally
      Reg.CloseKey;
    end;

  finally
    Reg.Free;
  end;

end;

procedure TTestForm.FormDestroy(Sender: TObject);
var
  Reg: TRegistry;
  DataSize: Integer;
  Data: Pointer;
begin
  MyDigits.Free;

  try
    Reg := TRegistry.Create;
    Reg.RootKey := HKEY_DYN_DATA;
    Reg.OpenKey('PerfStats\StopStat', False);
    DataSize := Reg.GetDataSize('KERNEL\CPUUsage');
    Reg.ReadBinaryData('KERNEL\CPUUsage', Data, DataSize);
    Reg.CloseKey;
  finally
    Reg.Free;
  end;
end;

procedure TTestForm.Timer1Timer(Sender: TObject);
var
  Reg: TRegistry;
  DataSize: Integer;
  Data: Longint;
begin
  try
    Reg := TRegistry.Create;
    Reg.RootKey := HKEY_DYN_DATA;

    try
      Reg.OpenKey('PerfStats\StatData', False);
      DataSize := Reg.GetDataSize('KERNEL\CPUUsage');
      Reg.ReadBinaryData('KERNEL\CPUUsage', Data, DataSize);

      DigitalDisplay1.Value := Data;
      //Readout.Value := Data;
    finally
      Reg.CloseKey;
    end;

  finally
    Reg.Free;
  end;
end;

end.
