unit Service;

interface

uses Customer;

type
  TService = class(TObject)
  private
    Busy: Boolean;
    Customer: TCustomer;
  public
    destructor Destroy; override;
    function IsBusy: Boolean;
    procedure Serve;
    procedure SetCustomer(Cust: TCustomer);
    function RemoveCustomer: TCustomer;
    function GetCustomerServiceTime: Longint;
  end;

implementation

destructor TService.Destroy;
begin
  if Assigned(Customer) then
    Customer.Free;
end;

function TService.IsBusy: Boolean;
begin
  Result := Busy;
end;

procedure TService.Serve;
begin
  if Assigned(Customer) then
  begin
    Customer.Serve;
    if Customer.IsCompleted then
      Busy := False
    else
      Busy := True
  end;
end;

procedure TService.SetCustomer(Cust: TCustomer);
begin
  Customer := Cust;
  Busy := True;
end;

function TService.RemoveCustomer: TCustomer;
begin
  Busy := False;
  Result := Customer;
  Customer := nil;
end;

function TService.GetCustomerServiceTime: Longint;
begin
  if Assigned(Customer) then
    Result := Customer.GetServiceTime
  else
    Result := 0;
end;

end.
