unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,
  Customer, Service;

const
  MAXSERVICETIME = 4;
  MAXINTERVAL = 4;

type
  TFrmMain = class(TForm)
    TmrClock: TTimer;
    BtnStart: TButton;
    BtnStop: TButton;
    LblMemoryCaption: TLabel;
    PnlTime: TPanel;
    LblTimeCaption: TLabel;
    LblNextCaption: TLabel;
    LblTime: TLabel;
    LblNext: TLabel;
    PnlService: TPanel;
    LblServiceStatusCaption: TLabel;
    LblServiceStatus: TLabel;
    LblServiceTime: TLabel;
    LblServiceTimeCaption: TLabel;
    LblLongestCaption: TLabel;
    LblQueue: TLabel;
    LstQueue: TListBox;
    LblLongest: TLabel;
    LblMemory: TLabel;
    LblCustomerCountCaption: TLabel;
    LblCustomerCount: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TmrClockTimer(Sender: TObject);
    procedure BtnStartClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
  private
    Customers: TCustomerList;
    Service: TService;
    NextArrival: Longint;
    CurrentTime: Longint;
    LongestQueue: Longint;
    procedure UpdateLabels;
    function MakeCustomerString(
      const Cust: TCustomer): string;
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.DFM}

procedure TFrmMain.FormCreate(Sender: TObject);
var FirstCustomer: TCustomer;
begin
  Randomize;
  NextArrival := Random(MAXINTERVAL) + 1;
  CurrentTime := 0;
  LongestQueue := 0;
  Customers := TCustomerList.Create;
  Service := TService.Create;
  UpdateLabels;
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
begin
  Customers.Free;
  Service.Free;
end;

procedure TFrmMain.TmrClockTimer(Sender: TObject);
var
  NextCustomer: TCustomer;
  CurrentCustomer: TCustomer;
  LastCustomer: TCustomer;
  CustStr: string;
begin
  Inc(CurrentTime);
  if CurrentTime = NextArrival then
  begin
    NextCustomer := TCustomer.Create;
    NextCustomer.SetArrivalTime(CurrentTime);
    NextCustomer.SetServiceTime(Random(MAXSERVICETIME) + 1);
    CustStr := MakeCustomerString(NextCustomer);
    LstQueue.Items.Add(CustStr);
    Customers.InsertAtBack(NextCustomer);
    if Customers.GetItemCount > LongestQueue then
      LongestQueue := Customers.GetItemCount;
    NextArrival := CurrentTime + Random(MAXINTERVAL) + 1;
  end;

  Service.Serve;

  if not Service.IsBusy then
  begin
    LastCustomer := Service.RemoveCustomer;
    LastCustomer.Free; { Destroy checks for nil }
    if not Customers.IsEmpty then
    begin
      CurrentCustomer := Customers.RemoveFromFront;
      CustStr := MakeCustomerString(CurrentCustomer);
      if LstQueue.Items[0] = CustStr then
        LstQueue.Items.Delete(0);
      Service.SetCustomer(CurrentCustomer);
    end;
  end;
  UpdateLabels;
end;

function TFrmMain.MakeCustomerString(
  const Cust: TCustomer): string;
begin
  Result := 'Saapumisaika = ' +
    IntToStr(Cust.GetArrivalTime) +
    '; Palveluaika = ' +
    IntToStr(Cust.GetServiceTime);
end;

procedure TFrmMain.UpdateLabels;
begin
  LblTime.Caption := IntToStr(CurrentTime);
  LblNext.Caption := IntToStr(NextArrival);
  LblMemory.Caption := IntToStr(MemAvail);
  if Service.IsBusy then
  begin
    LblServiceStatus.Color := clRed;
    LblServiceStatus.Caption := 'VARATTU';
    LblServiceTime.Caption :=
      IntToStr(Service.GetCustomerServiceTime);
  end
  else
  begin
    LblServiceStatus.Color := clGreen;
    LblServiceStatus.Caption := 'VAPAA';
    LblServiceTime.Caption := '';
  end;
  LblLongest.Caption := IntToStr(LongestQueue);
  LblCustomerCount.Caption := IntToStr(GetCustomerCount);
end;

procedure TFrmMain.BtnStartClick(Sender: TObject);
begin
  TmrClock.Enabled := True;
end;

procedure TFrmMain.BtnStopClick(Sender: TObject);
begin
  TmrClock.Enabled := False;
end;

end.
