unit Customer;

interface

type
  TCustomer = class(TObject)
  private
    ArrivalTime: Longint;
    ServiceTime: Longint;
    Next: TCustomer;
  public
    constructor Create; virtual;
    destructor Destroy; override;
    procedure SetArrivalTime(NewTime: Longint);
    procedure SetServiceTime(NewTime: Longint);
    function GetArrivalTime: Longint;
    function GetServiceTime: Longint;
    procedure Serve;
    function IsCompleted: Boolean;
  end;

  TCustomerList = class(TObject)
  private
    First, Last: TCustomer;
    Count: Longint;
  public
    destructor Destroy; override;
    function IsEmpty: Boolean;
    function GetItemCount: Longint;
    procedure InsertAtFront(NewItem: TCustomer);
    procedure InsertAtBack(NewItem: TCustomer);
    function RemoveFromFront: TCustomer;
    function RemoveFromBack: TCustomer;
  end;

function GetCustomerCount: Longint;

implementation

var
  CustomerCount: Longint;

function GetCustomerCount: Longint;
begin
  Result := CustomerCount;
end;

constructor TCustomer.Create;
begin
  inherited Create;
  Inc(CustomerCount);
end;

destructor TCustomer.Destroy;
begin
  Dec(CustomerCount);
  inherited Destroy;
end;

procedure TCustomer.SetArrivalTime(NewTime: Longint);
begin
  ArrivalTime := NewTime;
end;

procedure TCustomer.SetServiceTime(NewTime: Longint);
begin
  ServiceTime := NewTime;
end;

function TCustomer.GetArrivalTime: Longint;
begin
  Result := ArrivalTime;
end;

function TCustomer.GetServiceTime: Longint;
begin
  Result := ServiceTime;
end;

procedure TCustomer.Serve;
begin
  Dec(ServiceTime);
end;

function TCustomer.IsCompleted: Boolean;
begin
  Result := (ServiceTime < 1);
end;

{-----------------------------------------------------------}


destructor TCustomerList.Destroy;
var
  Current, Temp: TCustomer;
begin
  if not IsEmpty then
  begin
    Current := First;
    while Current <> nil do
    begin
      Temp := Current;
      Current := Current.Next;
      Temp.Free;
    end;
  end;
  Count := 0;
  inherited Destroy;
end;

procedure TCustomerList.InsertAtFront(NewItem: TCustomer);
begin
  if IsEmpty then
  begin
    First := NewItem;
    Last := NewItem;
  end
  else
  begin
    NewItem.Next := First;
    First := NewItem;
  end;
  Inc(Count);
end;

procedure TCustomerList.InsertAtBack(NewItem: TCustomer);
begin
  if IsEmpty then
  begin
    First := NewItem;
    Last := NewItem;
  end
  else
  begin
    Last.Next := NewItem;
    Last := NewItem;
  end;
  Inc(Count);
end;

function TCustomerList.RemoveFromFront: TCustomer;
var
  Temp: TCustomer;
begin
  if IsEmpty then
    Result := nil
  else
  begin
    Temp := First;
    if First = Last then
    begin
      First := nil;
      Last := nil;
    end
    else
      First := First.Next;
    Dec(Count);
    Result := Temp;
  end;
end;

function TCustomerList.RemoveFromBack: TCustomer;
var
  Temp, Current: TCustomer;
begin
  if IsEmpty then
    Result := nil
  else
  begin
    Temp := Last;
    if First = Last then
    begin
      First := nil;
      Last := nil;
    end
    else
    begin
      Current := First;
      while Current.Next = Last do
        Current := Current.Next;
      Last := Current;
      Current.Next := nil;
    end;
    Dec(Count);
    Result := Temp;
  end;
end;

function TCustomerList.IsEmpty: Boolean;
begin
  Result := (First = nil);
end;

function TCustomerList.GetItemCount: Longint;
begin
  Result := Count;
end;

begin
  CustomerCount := 0;
end.

