{
  HUKKA.PAS -- laskee FAT-osiolla olevan hukkatilan
  varausyksikn koon perusteella.
  Kytt:    hukka [d:]     (d: = osion asematunnus)
  Copyright (C) 1996 Jere Kpyaho
}

program Hukka;

uses
  Crt, Dos;

var
  disk_size, disk_free, cluster_size,
  total_bytes, total_alloc, slack_bytes : longint;
  free_percentage, wasted_percentage : real;
  old_dir, drive_spec : string;
  file_count, dir_count : integer;
  spin_pos : integer;

procedure SpinPropeller;
const
  PROP_LEN = 4;
  prop_str : array [1..PROP_LEN] of char = '|/-\';
begin
  GotoXY( WhereX - 1, WhereY );
  if (spin_pos >= 1) and (spin_pos <= PROP_LEN) then
  begin
    Write( prop_str[ spin_pos ] );
    Inc( spin_pos );
    if spin_pos = PROP_LEN then
      spin_pos := 1;
  end;
end;

procedure MakeUpperCase( var s : string );
var i : byte;
begin
  for i := 1 to Length( s ) do
    s[ i ] := UpCase( s[ i ] )
end;

procedure ProcessDirectory( path : string );
var
  sr : SearchRec;
  next_path : string;
begin
  Inc( dir_count );
  ChDir( path );

  FindFirst( '*.*', ReadOnly or Hidden or SysFile or Archive, sr );
  while DosError = 0 do
  begin
    Inc( file_count );
    Inc( total_bytes, sr.Size );
    if sr.Size < cluster_size then
      Inc( slack_bytes, cluster_size - sr.Size )
    else
      Inc( slack_bytes, sr.Size mod cluster_size );
    SpinPropeller;
    FindNext( sr );
  end;

  FindFirst( '*.*', Directory, sr );
  while DosError = 0 do
  begin
    if ((sr.Attr and Directory) <> 0) then
      if sr.Name[1] <> '.' then
      begin
        if path = '\' then
          next_path := path + sr.Name
        else
          next_path := path + '\' + sr.Name;
        ProcessDirectory( next_path );
        {$I-} ChDir( '..' ); {$I+}
      end;
    FindNext( sr );
  end;
end;

procedure Analyze;
var
  regs : Registers;
begin
  regs.AH := $36;
  regs.DL := 0;
  MsDos( regs );
  if regs.AX <> $FFFF then
  begin
    cluster_size := regs.AX * regs.CX;    { AX = sectors per cluster, CX = bytes per sector }
    disk_size := regs.DX * cluster_size;  { DX = clusters per drive }
    disk_free := regs.BX * cluster_size;  { BX = avail. clusters }
  end else begin
    WriteLn( 'Aseman ', drive_spec, ' tietoja ei pysty lukemaan!' );
    ChDir( old_dir );  { vaihda takaisin vanhaan tyhakemistoon }
    Halt;
  end;

  total_alloc := disk_size - disk_free;
  free_percentage := 100.0 - ((total_alloc / disk_size) * 100.0);

  file_count := 0;   dir_count := 0;
  total_bytes := 0;  slack_bytes := 0;
  spin_pos := 1;
  ProcessDirectory( '\' );  { aloita juurihakemistosta }
  wasted_percentage := (slack_bytes / disk_size) * 100.0;
end; { Analyze }

procedure Report;
begin
  GotoXY( 1, WhereY );

  WriteLn( 'Asema                               : ', drive_spec );
  WriteLn( 'Koko tavuina                        : ', disk_size:10 );
  WriteLn( 'Vapaa tila tavuina                  : ', disk_free:10 );
  WriteLn( 'Vapaa tila prosentteina levytilasta : ', free_percentage:8:1, ' %' );
  WriteLn( 'Varausyksikn koko tavuina          : ', cluster_size:10 );

  WriteLn( 'Hakemistoja yhteens kpl            : ', dir_count:10 );
  WriteLn( 'Tiedostoja yhteens kpl             : ', file_count:10 );
  WriteLn( 'Tiedostojen yhteiskoko tavuina      : ', total_bytes:10 );
  WriteLn( 'Varattu tila tavuina                : ', total_alloc:10 );
  WriteLn( 'Hukkatilan mr tavuina            : ', slack_bytes:10 );
  WriteLn( 'Hukkatila prosentteina levytilasta  : ', wasted_percentage:8:1 , ' %' );
  WriteLn;

  ChDir( old_dir );  { vaihda takaisin vanhaan tyhakemistoon }
end;

begin
  WriteLn;
  WriteLn( 'HUKKA v1.0  Copyright (c) 1996 Jere Kpyaho' );
  WriteLn( 'Laskee levyn hukkatilan varausyksikn koon perusteella.' );

  GetDir( 0, old_dir );  { tallenna tyhakemisto }
  MakeUpperCase( old_dir );
  drive_spec := Copy( old_dir, 1, 2 ); { kopioi aseman kirjain ja ':' }

  if ParamCount > 0 then
  begin
    drive_spec := ParamStr( 1 );
    MakeUpperCase( drive_spec );
{$I-}
    ChDir( drive_spec + '\' );
{$I+}
    if IOResult <> 0 then
    begin
      WriteLn( drive_spec, ' ei ole kelvollinen asematunnus.' );
      Halt;
    end;
  end;

  Write( 'Analyysi kynniss - odota hetkinen...  ' );
  Analyze;
  Report;
end.
