#include <dos.h>
#include <stdio.h>
#include <conio.h>

typedef unsigned char byte;

//*** Perustason liitntfunktiot ***//

// Palauttaa 8042-piirin statuksen eli tilan
byte inline status_8042(void) {
	return(inportb(0x64));
}

// Sytt komennon 8042-piirille
void inline command_8042(byte type) {
	outportb(0x64,type);
}

// Sytt tietoa nppimistlle tai 8042-piirin komentoon
//  liittyvn listiedon
// Voi kytt vain jos tilabitti 1 on tyhj
// Jos tilabitti 3 on tyhj, menee tavu nppimistlle, muuten
//  se j ohjainpiirille
int input_8042(byte data) {
	int register counter=0;
	while((status_8042()&2)!=0 && !(counter&1024)) counter++;
	if (!(counter&1024)) outportb(0x60,data);
	else return(-1);
	return(0);
}

// Lukee 8042-piirin ulostulon
// Voi kytt vain jos tilabitti 0 on asetettu
int inline output_8042(void) {
	if ((status_8042()&1)!=0) return(inportb(0x60));
	return(-1);
}

//*** Korkeamman tason liityntfunktiot ***//
//*** Tss vain esimerkkej muutamista komennoista ***//

void inline disable_8042(void) {
	command_8042(0xAD);
}

void inline enable_8042(void) {
	command_8042(0xAD);
}

// CPU reset!
void reset(void) {
	command_8042(0xFE);	// Lhett sykyksen reset-linjalle (0xF0 toimii mys)
}

// Itsetesti - tulos on 55h jos kaikki on kunnossa
byte selftest(void) {
	byte register status;
	disable_8042();
	command_8042(0xAA);
	status=output_8042();
	enable_8042();
	return(status);
}

// LEDien asetukset kahdella eri tavalla
void LED(byte num,byte caps,byte scroll) {
	byte register databyte=(scroll?1:0)+(num?2:0)+(caps?4:0);
	input_8042(0xED);
	input_8042(databyte);
}
void LED(byte value) {
	input_8042(0xED);
	input_8042(value);
}

// Typematic delay/rate: alkuviive (250,500,750 tai 1000 ms)
// ja toistonopeus (0..31 nopeimmasta hitaimpaan)
void typematic(int dl,int r) {
	if ((dl!=250 && dl!=500 && dl!=750 && dl!=1000) || (r<0 || r>31)) return;
	byte register databyte=((dl/250-1)<<5)+r;
	input_8042(0xF3);
	input_8042(databyte);
}

int main(void) {
	char rivi[81];
	byte n,c,s;
	int r;
	printf("\nNppimistn itsetesti: %Xh\n",selftest());
	// Vlkytetn ledej
	printf("\nVilkaisepa nppimistn valoja...\n");
	for(n=0;n<2;n++)
		for(c=0;c<2;c++)
			for(s=0;s<2;s++) {
				LED(n,c,s);
				delay(400);
			}
	for(n=0;n<14;n++) for(s=0;s<4;s++) {
		LED(s==3?0:1<<s);
		delay(90);
	}
	// Testataan toistonopeutta
	typematic(1000,31);
	printf("\nKokeile toistonopeutta: ");
	gets(rivi);
	typematic(250,0);
	printf("\nKokeile uudelleen: ");
	gets(rivi);
	printf("\nHaluatko resetin? Paina ESC jos et halua.\n");
	if (getch()!=27) reset();
	LED(0,0,0);
	return(0);
}