#include <conio.h>
#include <dos.h>

volatile char napit[0x80],    /*Nppinten asennot*/
							viimeisin,      /*Viimeisen painettu*/
							counter=0;      /*Montako painettu*/

#ifdef __BORLANDC__
	#ifdef __cplusplus
		#define INTARG ...
	#else
		#define INTARG void
	#endif

	/*Keskeytysosoitin alk.per vektoria varten*/
	void interrupt (*vanha_i9)(INTARG);

	/*Uusi nppimistkeskeytys*/
	void interrupt uusi_i9(INTARG) {
		/*Luetaan nppintieto portista 60h*/
		unsigned char register ch=inportb(0x60);
		if (ch<0x80) {  /*Jos arvo <80h on nappi painettu*/
			if (!napit[ch]) counter++;
			napit[ch]=1;
			viimeisin=ch;
		} else {  /*Jos arvo >80h on nappi vapautettu*/
			if (napit[ch^0x80]) counter--;
			napit[ch^0x80]=0;
		}
		outportb(0x20,0x20); /*Keskeytys on pttynyt*/
	}

	void koukuta_i9(void) {
		vanha_i9=getvect(0x9); /*Otetaan vanha vektori talteen*/
		setvect(0x9,uusi_i9);  /*Asetetaan uusi keskeytys*/
	}

	void vapauta_i9(void) {
		setvect(0x9,vanha_i9); /*Palautetaan alkuperinen vektori*/
	}
#else
	#include <go32.h>
	#include <dpmi.h>

	_go32_dpmi_seginfo si_vanha,si_uusi;

	void uusi_i9(void) {
		/*Luetaan nppintieto portista 60h*/
		unsigned char ch=inportb(0x60);
		if (ch<0x80) {  /*Jos arvo <80h on nappi painettu*/
			if (!napit[ch]) counter++;
			napit[ch]=1;
			viimeisin=ch;
		} else {  /*Jos arvo >80h on nappi vapautettu*/
			if (napit[ch^0x80]) counter--;
			napit[ch^0x80]=0;
		}
		outportb(0x20,0x20); /*Keskeytys on pttynyt*/
	}

	void koukuta_i9(void) {
  	/*Vanha vektori talteen*/
		_go32_dpmi_get_protected_mode_interrupt_vector(0x9,&si_vanha);
		/*Uuden osoite kenttn*/
		si_uusi.pm_offset=(long unsigned int)uusi_i9;
		/*Wrapperin luominen*/
		_go32_dpmi_allocate_iret_wrapper(&si_uusi);
		/*Koodisegmentin haku*/
		si_uusi.pm_selector=_go32_my_cs();
		/*Keskeytysvektorin pivitys*/
		_go32_dpmi_set_protected_mode_interrupt_vector(0x9,&si_uusi);
	}

	void vapauta_i9(void) {
		/*Keskeytysvektorin pivitys*/
		_go32_dpmi_set_protected_mode_interrupt_vector(0x9,&si_vanha);
		/*Wrapperin poisto*/
		_go32_dpmi_free_iret_wrapper(&si_uusi);
	}
#endif

int main(void) {
	koukuta_i9();	/*Koukutetaan oikea vektori*/
	cprintf("\r\nPaina ESC lopettaaksesi\r\n");
	while (napit[1]==0) { /*Odotetaan kunnes ESC painetaan*/
		cprintf("\rViimeksi painettu: %2Xh",viimeisin);
		cprintf("  Nappeja pohjassa: %i  ",counter);
	}
	vapauta_i9(); /*Vapautetaan koukutettu vektori*/
	return(0);
}
