/*
	Hiirenksittelydemo, MikroBitti 4/96.
	Copyright 1996 Tarmo Toikkanen, MikroBitti

	Tm koodi kntyy sellaisenaan sek Borlandin C:ll ett MBnetist
	saatavalla ilmaisella DJGPP-kntjll.

	Ohjelman kntminen Borlandilla: bcc -ml mouse.c
												 DJGPP:ll: gcc mouse.c -lpc -o mouse.out
																		strip mouse.out
																		coff2exe mouse.out
*/

#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>

/* Jos et kyt DJGPP:t, voit poistaa koodista kaikki rivit joiden
	 ymprill on merkinnt "DJGPP..." ja "...DJGPP" */

#ifndef __BORLANDC__	/*DJGPP...*/
	#include <djgppstd.h>
	#include <pc.h>
	#include <dpmi.h>
	#define far
	/* Osoitin tekstitilan videomuistiin */
	char far *ruutu=(char far *)0xE00B8000;
#else									/*...DJGPP*/
	char far *ruutu=(char far *)0xB8000000;
#endif

#ifdef __cplusplus
	#define __CPPARGS ...
#else
	#define __CPPARGS
#endif

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;

/* Hiiren nappien numerot */
#define VASEN    0
#define OIKEA    1
#define KESKI    2

#define ALAS     0
#define YLOS     1

/* Nappien bittimaskit */
const byte maski[3]={1,2,4};

/* Muutos: kertoo montako kertaa napin tila on muuttunut sek
	 viimeisimmn muutoksen koordinaatit */
struct MUUTOS {
	word kpl,						/* Montako kertaa painettu */
			 x,y;						/* Viimeisen painon koordinaatit */
};

/* Nappi: kertoo napin nykyisen asennon sek Muutokset yls- ja alaspin
	 (eli painallukset ja vapautukset) */
struct NAPPI {
	word nyt;						/* Napin asento (1: painettu, 0: irti) */
	struct MUUTOS m[2];	/* Muutokset (0: yls, 1:alas) */
};

/* Hiiri: kertoo nappien lukumrn, hiiren koordinaatit, liikemrn sek
	 nappien tiedot. C++:ssa kannattaa lisksi kaikki hiirifunktiot tehd
	 structin sisisiksi jsenfunktioikis. */
struct HIIRI {
	byte nappeja;				/* Nappien mr */
	word x,y;						/* X- ja Y-koordinaatit */
	short dx,dy;				/* X- ja Y-siirtymt */
	struct NAPPI n[3];	/* Kolmen napin tiedot */
} h;

/* Rekisteripaketti kaikkiin hiirifunktioihin */
union REGS r;

/* Tarkistaa, onko hiiri kytss, tallettaa nappien mrn
	 ja alustaa hiiren
	 PALAUTUS: hiiren nappien lukumr
	 MUUTOKSET: h.nappeja */
short H_tarkista(void) {
	r.x.ax=0x0000;
	int86(0x33,&r,&r);
	if (!r.x.ax) h.nappeja=0;					/* Hiiriajuria ei lydy */
	if (r.x.bx==3) h.nappeja=3;				/* Kolmenappinen hiiri */
	else if (r.x.bx==0) h.nappeja=1;	/* Ei kahta (eli yksi) */
	else h.nappeja=2;									/* Kaksinappinen hiiri */
	return(h.nappeja);
}

/* Tekee hiiren nkyvksi */
void H_nakyviin(void) {
	r.x.ax=0x0001;
	int86(0x33,&r,&r);
}

/* Tekee hiiren nkymttmksi */
void H_piiloon(void) {
	r.x.ax=0x0002;
	int86(0x33,&r,&r);
}

/* Lukee hiiren sijainnin ja sen nappien asennot
	 MUUTOKSET: h.n[].nyt: nappien asennot
							h.x, h.y: hiiren sijainti */
void H_lue(void) {
	r.x.ax=0x0003;
	int86(0x33,&r,&r);
	h.n[VASEN].nyt=r.h.bl&maski[VASEN]?1:0;
	h.n[OIKEA].nyt=r.h.bl&maski[OIKEA]?1:0;
	h.n[KESKI].nyt=r.h.bl&maski[KESKI]?1:0;
	h.x=r.x.cx;
	h.y=r.x.dx;
}

/* Siirt hiiren uuteen kohtaan
	 PARAMETRIT: x,y: uuden sijainnin koordinaatit
										(tekstitilassa yleens 8x8 on yksi merkki)
	 MUUTOKSET: h.x, h.y: hiiren sijainti */
void H_liikuta(word x,word y) {
	r.x.ax=0x0004;
	r.x.cx=x;
	r.x.dx=y;
	int86(0x33,&r,&r);
	H_lue();
}

/* Tutkii tiedot tietyn napin viimeisest painalluksesta
	 PARAMETRIT: napin numero
	 PALAUTUS: napin senhetkinen asento
	 MUUTOKSET: h.n[].nyt: napin senhetkinen asento
							h.n[].m[ALAS]: napin painallusten mr viime tarkistuksen
														 jlkeen ja sijainti viimeisimmn aikana */
byte HN_alas(byte nappi) {
	r.x.ax=0x0005;
	r.x.bx=nappi;
	int86(0x33,&r,&r);
	h.n[nappi].nyt=r.h.al&maski[nappi]?1:0;
	h.n[nappi].m[ALAS].kpl=r.x.bx;
	h.n[nappi].m[ALAS].x=r.x.cx;
	h.n[nappi].m[ALAS].y=r.x.dx;
	return(h.n[nappi].nyt);
}

/* Tutkii tiedot tietyn napin viimeisest vapautuksesta
	 PARAMETRIT: napin numero
	 PALAUTUS: napin senhetkinen asento
	 MUUTOKSET: h.n[].nyt: napin senhetkinen asento
							h.n[].m[YLOS]: napin vapautusten mr viime tarkistuksen
														 jlkeen ja sijainti viimeisimmn aikana */
byte HN_ylos(byte nappi) {
	r.x.ax=0x0006;
	r.x.bx=nappi;
	int86(0x33,&r,&r);
	h.n[nappi].nyt=r.h.al&maski[nappi]?1:0;
	h.n[nappi].m[YLOS].kpl=r.x.bx;
	h.n[nappi].m[YLOS].x=r.x.cx;
	h.n[nappi].m[YLOS].y=r.x.dx;
	return(h.n[nappi].nyt);
}

/* Mritt uudet liikkumarajat hiirelle
	 PARAMETRIT: xmin: pienin sallittu x-koordinaatti
							 xmax: suurin sallittu x-koordinaatti
							 ymin: pienin sallittu y-koordinaatti
							 ymax: suurin sallittu y-koordinaatti */
void H_rajat(word xmin,word ymin,word xmax,word ymax) {
	r.x.ax=0x0007;
	r.x.cx=xmin;
	r.x.dx=xmax;
	int86(0x33,&r,&r);
	r.x.ax=0x0008;
	r.x.cx=ymin;
	r.x.dx=ymax;
	int86(0x33,&r,&r);
}

/* Tutkii hiiren liikemr
	 MUUTOKSET: h.dx, h.dy: liikemrt mikkein viime tarkistuksen jlkeen */
void H_siirros(void) {
	r.x.ax=0x000B;
	int86(0x33,&r,&r);
	h.dx=r.x.cx;
	h.dy=r.x.dx;
}

#ifdef __BORLANDC__

	/* Asettaa uuden hiiriksittelijn
		 PARAMETRIT: ehto: miss tilanteissa ksittelij kutsutaan
								 mousehandler: funktion osoite */
	void H_handler(word ehto,void far (*mousehandler)) {
		struct SREGS sr;
		sr.es=FP_SEG(mousehandler);
		r.x.dx=FP_OFF(mousehandler);
		r.x.ax=0xC;
		r.x.cx=ehto;
		int86x(0x33,&r,&r,&sr);
	}

	/* Esimerkki hiiriksittelijst. Parametrit ovat C++:ssa (...)
		 ja C:ss () */
	void _loadds handler(__CPPARGS) {
		word bx=_BX,cx=_CX,dx=_DX; 		/* Mys ax, si ja di sisltvt tietoa */
		h.n[VASEN].nyt=bx&maski[VASEN]?1:0;
		h.n[OIKEA].nyt=bx&maski[OIKEA]?1:0;
		h.x=cx; h.y=dx;
		if (h.n[VASEN].nyt) {
			ruutu[(h.y*20+h.x/4)]='1';
			ruutu[(h.y*20+h.x/4)+1]=15;
		} else {
			ruutu[(h.y*20+h.x/4)]='0';
			ruutu[(h.y*20+h.x/4)+1]=7;
		}
	}

#else										/*DJGPP...*/

	_go32_dpmi_seginfo _32_hseg;
	_go32_dpmi_registers _32_hreg,_32_reg;

	void handler(__CPPARGS) {
		h.n[VASEN].nyt=_32_hreg.x.bx&maski[VASEN]?1:0;
		h.n[OIKEA].nyt=_32_hreg.x.bx&maski[OIKEA]?1:0;
		h.x=_32_hreg.x.cx; h.y=_32_hreg.x.dx;
		if (h.n[VASEN].nyt) {
			ruutu[(h.y*20+h.x/4)]='1';
			ruutu[(h.y*20+h.x/4)+1]=15;
		} else {
			ruutu[(h.y*20+h.x/4)]='0';
			ruutu[(h.y*20+h.x/4)+1]=7;
		}
	}

	void H_handler(word ehto,void (*mousehandler)(__CPPARGS)) {
		memset(&_32_reg,0,sizeof(_go32_dpmi_registers));
		_32_hseg.pm_offset=(unsigned long int)mousehandler;
		_go32_dpmi_allocate_real_mode_callback_retf(&_32_hseg,&_32_hreg);
		_32_reg.x.ax=0xC;
		_32_reg.x.cx=ehto;
		_32_reg.x.dx=_32_hseg.rm_offset;
		_32_reg.x.es=_32_hseg.rm_segment;
		_go32_dpmi_simulate_int(0x33,&_32_reg);
	}

#endif									/*...DJGPP*/

int main(void) {
	char ch;
	printf("\nHiiridemo, Copyright 1995 Tarmo Toikkanen, Mikrobitti\n");
	if (!H_tarkista()) {	/* Tarkistetaan hiiriajuri */
		printf("\nHiiriajuri puuttuu!\n");
		return(1);
	}
	printf("\n%i-nappinen hiiri lytyi!\n",h.nappeja);
	printf("\nPainamalla vlilynti kytt ohjelma itse tehty\n"
				 "hiirenksittelyfunktiota. Mik tahansa muu nappi ajaa demon\n"
				 "manuaalisessa hiirenksittelytilassa.\n");
	ch=getch();
	H_nakyviin();					/* Hiiri nkyviin */
	if (ch==32) {
		printf("\nPohjelma j nyt odottamaan nppimistn napin painallusta.\n"
					 "Hiiriajuri kutsuu itse tehty ksittelijyfunktiota aina kun\n"
					 "painat tai vapautat hiiren vasemman napin, jolloin ruudulle\n"
					 "ilmestyy hiirikursorin kohdalle 1 tai 0. Paina mit tahansa\n"
					 "nppimistn nappia lopettaaksesi.\n");
		H_handler(6,handler);	/* Asennetaan oma hiiriksittelij */
		while(!kbhit());
		#ifndef __BORLANDC__	/*DJGPP...*/
		_go32_dpmi_free_real_mode_callback(&_32_hseg);
		#endif								/*...DJGPP*/
	} else {
		printf("\nPohjelma lukee hiiren tietoja jatkuvasti ja nytt osan\n"
					 "niist alimmalla rivill. Paina mit tahansa nppimistn\n"
					 "nappia lopettaaksesi.\n");
		while(!kbhit()) {
			H_lue();
			cprintf("\rX: %3i Y: %3i  Vasen: %i Keski: %i Oikea: %i",
							h.x/8,h.y/8,
							h.n[VASEN].nyt?1:0,h.n[KESKI].nyt?1:0,h.n[OIKEA].nyt?1:0);
		}
	}
	return(0);
}